/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.codec;

import de.gematik.bbriccs.fhir.codec.ResourceTypeHint;
import de.gematik.bbriccs.fhir.coding.WithStructureDefinition;
import de.gematik.bbriccs.fhir.coding.version.ProfileVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ResourceTypeHintTest {
    ResourceTypeHintTest() {
    }

    @Test
    void shouldNotAllowRegistrationForAllVersionsIfNotEnum() {
        ResourceTypeHint.Builder typeHintBuilder = ResourceTypeHint.forStructure((WithStructureDefinition)new MyStructureDefinition());
        Assertions.assertThrows(IllegalArgumentException.class, () -> typeHintBuilder.forAllVersionsFrom(MyCustomVersion.class));
    }

    private static class MyStructureDefinition
    implements WithStructureDefinition<MyCustomVersion> {
        private MyStructureDefinition() {
        }

        public String getCanonicalUrl() {
            return "https://example.com";
        }

        public String getVersionedUrl(MyCustomVersion version) {
            return "https://example.com/" + version.getVersion();
        }
    }

    private static class MyCustomVersion
    implements ProfileVersion {
        private MyCustomVersion() {
        }

        public String getVersion() {
            return "1.0.0";
        }

        public String getName() {
            return "my.custom.version";
        }
    }
}

