/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.codec;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.bbriccs.fhir.coding.ProfileStructureDefinition;
import de.gematik.bbriccs.fhir.coding.version.ProfileVersion;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.Resource;

public class ResourceTypeHint<T extends ProfileVersion, R extends Resource> {
    private final ProfileStructureDefinition<T> definition;
    @Nullable
    private final T version;
    private final Class<R> mappingClass;

    private ResourceTypeHint(ProfileStructureDefinition<T> definition, @Nullable T version, Class<R> mappingClass) {
        this.definition = definition;
        this.version = version;
        this.mappingClass = mappingClass;
    }

    public void register(FhirContext ctx) {
        if (this.version != null) {
            ctx.setDefaultTypeForProfile(this.definition.getVersionedUrl(this.version), this.mappingClass);
        } else {
            ctx.setDefaultTypeForProfile(this.definition.getCanonicalUrl(), this.mappingClass);
        }
    }

    public static <T extends ProfileVersion, R extends Resource> ResourceTypeHint<T, R> forStructure(ProfileStructureDefinition<T> definition, @Nullable T version, Class<R> mappingClass) {
        return new ResourceTypeHint<T, R>(definition, version, mappingClass);
    }

    public static <T extends ProfileVersion, R extends Resource> ResourceTypeHint<T, R> forStructure(ProfileStructureDefinition<T> definition, Class<R> mappingClass) {
        return new ResourceTypeHint<Object, R>(definition, null, mappingClass);
    }
}

