/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.codec;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.fhir.codec.FhirCodec;
import de.gematik.bbriccs.fhir.codec.ResourceTypeHint;
import de.gematik.bbriccs.fhir.codec.exceptions.FhirCodecException;
import de.gematik.bbriccs.fhir.codec.utils.FhirTest;
import de.gematik.bbriccs.fhir.coding.ProfileStructureDefinition;
import de.gematik.bbriccs.fhir.coding.version.GenericProfileVersion;
import de.gematik.bbriccs.fhir.coding.version.ProfileVersion;
import de.gematik.bbriccs.fhir.validation.DummyValidator;
import de.gematik.bbriccs.fhir.validation.ValidatorFhirFactory;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.refv.SupportedValidationModule;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class FhirCodecTest
extends FhirTest {
    FhirCodecTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldDecodeExampleHl7Patients(File file) {
        String content = ResourceLoader.readString((File)file);
        Patient patient = (Patient)Assertions.assertDoesNotThrow(() -> (Patient)this.fhirCodec.decode(Patient.class, content));
        Assertions.assertEquals((Object)"example", (Object)patient.getIdPart());
        Patient patient2 = (Patient)Assertions.assertDoesNotThrow(() -> (Patient)this.fhirCodec.decode(Patient.class, content));
        Assertions.assertEquals((Object)patient.getIdPart(), (Object)patient2.getIdPart());
    }

    static Stream<Arguments> shouldDecodeExampleHl7Patients() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/hl7/patient").stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"shouldDecodeExampleHl7Patients"})
    void shouldDecodeExampleHl7PatientsWithRefVal(File file) {
        String content = ResourceLoader.readString((File)file);
        FhirCodec codec = FhirCodec.forR4().andReferenzValidator(SupportedValidationModule.ERP);
        Patient patient = (Patient)Assertions.assertDoesNotThrow(() -> (Patient)codec.decode(Patient.class, content));
        Assertions.assertEquals((Object)"example", (Object)patient.getIdPart());
        Patient patient2 = (Patient)Assertions.assertDoesNotThrow(() -> (Patient)codec.decode(Patient.class, content));
        Assertions.assertEquals((Object)patient.getIdPart(), (Object)patient2.getIdPart());
    }

    @ParameterizedTest
    @MethodSource
    void shouldDecodeExampleHl7PatientsWithoutType(File file) {
        String content = ResourceLoader.readString((File)file);
        Resource patient = (Resource)Assertions.assertDoesNotThrow(() -> this.fhirCodec.decode(content));
        Assertions.assertEquals((Object)"example", (Object)patient.getIdPart());
        Assertions.assertEquals(Patient.class, patient.getClass());
    }

    static Stream<Arguments> shouldDecodeExampleHl7PatientsWithoutType() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/hl7/patient", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest(name="[{index}] Encode Patient with {0}")
    @EnumSource(value=EncodingType.class)
    void shouldEncodeExamples(EncodingType type) {
        Patient patient = new Patient();
        patient.getMeta().getProfile().add(new CanonicalType("https://gematik.de/test/patient"));
        Assertions.assertDoesNotThrow(() -> this.fhirCodec.encode((IBaseResource)patient, type));
    }

    @ParameterizedTest
    @MethodSource
    void shouldDecodeErpCommunication(File file) {
        String content = ResourceLoader.readString((File)file);
        Communication communication = (Communication)Assertions.assertDoesNotThrow(() -> (Communication)this.fhirCodec.decode(Communication.class, content));
        Reference basedOn = communication.getBasedOnFirstRep();
        Assertions.assertFalse((boolean)basedOn.getReference().startsWith("/Task"));
    }

    static Stream<Arguments> shouldDecodeErpCommunication() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/erx/1.2.0/communication", (boolean)true).stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @EnumSource(value=EncodingType.class)
    @Disabled(value="This test is not working because the reference is not correctly encoded.")
    void shouldEncodeCommunicationBasedOnCorrectly(EncodingType encodingType) {
        Communication communication = new Communication();
        communication.addBasedOn(new Reference("Task/160.000.033.491.280.78/$accept?ac=777bea0e13cc9c42ceec14aec3ddee2263325dc2c6c699db115f58fe423607ea"));
        String content = (String)Assertions.assertDoesNotThrow(() -> this.fhirCodec.encode((IBaseResource)communication, encodingType));
        Assertions.assertFalse((boolean)content.contains("/Task"));
        Assertions.assertTrue((boolean)content.contains("Task/160.000.033.491.280.78"));
    }

    @ParameterizedTest
    @MethodSource
    @Disabled(value="This test is not working because the reference is not correctly encoded.")
    void shouldEncodeCommunicationBasedOnCorrectlyWithPlainHAPI(IParser parser) {
        Communication communication = new Communication();
        communication.addBasedOn(new Reference("Task/123123/$accept?ac=ACCESS_CODE"));
        Assertions.assertEquals((Object)"Task/123123/$accept?ac=ACCESS_CODE", (Object)communication.getBasedOnFirstRep().getReference());
        String content = parser.encodeResourceToString((IBaseResource)communication);
        Assertions.assertFalse((boolean)content.contains("/Task"));
        Assertions.assertTrue((boolean)content.contains("Task/123123"));
    }

    static Stream<Arguments> shouldEncodeCommunicationBasedOnCorrectlyWithPlainHAPI() {
        return Stream.of(FhirContext.forR4().newJsonParser(), FhirContext.forR4().newXmlParser()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldDecodePatientExamplesWithTypeHint(File file) {
        String content = ResourceLoader.readString((File)file);
        GenericProfileVersion version = new GenericProfileVersion("1.1.0", false);
        FhirCodec typedFhir = FhirCodec.forR4().withTypeHint((ProfileStructureDefinition)TestKbvStructDef.KBV_PATIENT, (ProfileVersion)version, TestKbvPatient.class).andNonProfiledValidator();
        Resource patient = (Resource)Assertions.assertDoesNotThrow(() -> typedFhir.decode(content));
        Assertions.assertEquals(TestKbvPatient.class, patient.getClass());
    }

    static Stream<Arguments> shouldDecodePatientExamplesWithTypeHint() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/kbv/1.1.0/patient").stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldDecodePatientExamplesWithTypeHintAndNoVersion(File file) {
        String content = ResourceLoader.readString((File)file);
        FhirCodec typedFhir = FhirCodec.forR4().withTypeHint((ProfileStructureDefinition)TestKbvStructDef.KBV_PATIENT, TestKbvPatient.class).andNonProfiledValidator();
        Resource patient = (Resource)Assertions.assertDoesNotThrow(() -> typedFhir.decode(content));
        Assertions.assertEquals(TestKbvPatient.class, patient.getClass());
    }

    static Stream<Arguments> shouldDecodePatientExamplesWithTypeHintAndNoVersion() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/invalid/kbv/patient").stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldDecodeExamplesWithMultipleTypeHints(File file) {
        String content = ResourceLoader.readString((File)file);
        GenericProfileVersion version = new GenericProfileVersion("1.1.0", false);
        FhirCodec typedFhir = FhirCodec.forR4().withTypeHint((ProfileStructureDefinition)TestKbvStructDef.KBV_PATIENT, (ProfileVersion)version, TestKbvPatient.class).withTypeHint((ProfileStructureDefinition)TestKbvStructDef.KBV_BUNDLE, (ProfileVersion)version, TestKbvBundle.class).andNonProfiledValidator();
        TestKbvBundle bundle = (TestKbvBundle)((Object)Assertions.assertDoesNotThrow(() -> (TestKbvBundle)typedFhir.decode(TestKbvBundle.class, content)));
        Assertions.assertEquals(TestKbvBundle.class, ((Object)((Object)bundle)).getClass());
        Assertions.assertEquals(TestKbvPatient.class, bundle.getPatient().getClass());
    }

    static Stream<Arguments> shouldDecodeExamplesWithMultipleTypeHints() {
        return ResourceLoader.getResourceFilesInDirectory((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle").stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"shouldDecodeExamplesWithMultipleTypeHints"})
    void shouldDecodeExamplesWithMultipleTypeHints02(File file) {
        String content = ResourceLoader.readString((File)file);
        GenericProfileVersion version = new GenericProfileVersion("1.1.0", false);
        List<ResourceTypeHint> typeHints = List.of(ResourceTypeHint.forStructure((ProfileStructureDefinition)TestKbvStructDef.KBV_PATIENT, (ProfileVersion)version, TestKbvPatient.class), ResourceTypeHint.forStructure((ProfileStructureDefinition)TestKbvStructDef.KBV_BUNDLE, (ProfileVersion)version, TestKbvBundle.class));
        FhirCodec typedFhir = FhirCodec.forR4().withTypeHints(typeHints).andNonProfiledValidator();
        TestKbvBundle bundle = (TestKbvBundle)((Object)Assertions.assertDoesNotThrow(() -> (TestKbvBundle)typedFhir.decode(TestKbvBundle.class, content)));
        Assertions.assertEquals(TestKbvBundle.class, ((Object)((Object)bundle)).getClass());
        Assertions.assertEquals(TestKbvPatient.class, bundle.getPatient().getClass());
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldDecodeEmptyResource(String content) {
        EmptyResource resource = (EmptyResource)Assertions.assertDoesNotThrow(() -> (EmptyResource)this.fhirCodec.decode(EmptyResource.class, content));
        Assertions.assertEquals(EmptyResource.class, resource.getClass());
    }

    static Stream<Arguments> shouldDecodeEmptyResource() {
        return Stream.of("", " ", "\t", "\n", "\r", "\r\n").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @EnumSource(value=EncodingType.class)
    void shouldEncodeEmptyResource(EncodingType encodingType) {
        String content = (String)Assertions.assertDoesNotThrow(() -> this.fhirCodec.encode((IBaseResource)new EmptyResource(), encodingType));
        Assertions.assertTrue((boolean)content.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"shouldDecodeExampleHl7Patients"})
    void shouldFailOnDecodingContentAsEmptyResource(File file) {
        String content = ResourceLoader.readString((File)file);
        Assertions.assertThrows(FhirCodecException.class, () -> this.fhirCodec.decode(EmptyResource.class, content));
    }

    @ParameterizedTest
    @MethodSource(value={"shouldDecodeExamplesWithMultipleTypeHints"})
    void shouldCreateWithConfiguredValidator(File file) {
        FhirCodec profiledCodec;
        String content = ResourceLoader.readString((File)file);
        try (MockedStatic validatorFactory = Mockito.mockStatic(ValidatorFhirFactory.class);){
            validatorFactory.when(ValidatorFhirFactory::createValidator).thenReturn((Object)new DummyValidator(FhirContext.forR4()));
            profiledCodec = FhirCodec.forR4().andBbriccsValidator();
        }
        TestKbvBundle bundle = (TestKbvBundle)((Object)Assertions.assertDoesNotThrow(() -> (TestKbvBundle)profiledCodec.decode(TestKbvBundle.class, content)));
        Assertions.assertNotNull((Object)((Object)bundle));
    }

    @Test
    void shouldDisableErrors() {
        FhirCodec fc = FhirCodec.forR4().disableErrors().andDummyValidator();
        Task t = new Task();
        Extension e = t.addExtension();
        e.setValue((Type)new StringType("Bricks"));
        e.addExtension("https://gematik.de/fhir", (Type)new StringType("Bricks"));
        Assertions.assertDoesNotThrow(() -> fc.encode((IBaseResource)t, EncodingType.XML));
    }

    public static enum TestKbvStructDef implements ProfileStructureDefinition<GenericProfileVersion>
    {
        KBV_PATIENT("https://fhir.kbv.de/StructureDefinition/KBV_PR_FOR_Patient"),
        KBV_BUNDLE("https://fhir.kbv.de/StructureDefinition/KBV_PR_ERP_Bundle");

        private final String canonicalUrl;

        @Generated
        public String getCanonicalUrl() {
            return this.canonicalUrl;
        }

        @Generated
        private TestKbvStructDef(String canonicalUrl) {
            this.canonicalUrl = canonicalUrl;
        }
    }

    public static class TestKbvPatient
    extends Patient {
    }

    public static class TestKbvBundle
    extends Bundle {
        public Patient getPatient() {
            return this.getEntry().stream().filter(entry -> entry.getResource().getResourceType().equals((Object)ResourceType.Patient)).map(entry -> (Patient)entry.getResource()).findFirst().orElseThrow();
        }
    }
}

