/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.toggle;

import de.gematik.bbriccs.toggle.BooleanToggle;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class BooleanToggleTest {
    BooleanToggleTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"booleanToggleInstances"})
    <T extends BooleanToggle> void shouldHaveKey(T instance) {
        Assertions.assertFalse((boolean)instance.getKey().isBlank());
        Assertions.assertFalse((boolean)instance.getKey().isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"booleanToggleInstances"})
    <T extends BooleanToggle> void shouldHaveDefaultValue(T instance) {
        Assertions.assertDoesNotThrow(() -> instance.getDefaultValue());
    }

    @ParameterizedTest
    @MethodSource(value={"booleanToggleInstances"})
    <T extends BooleanToggle> void shouldHaveConverter(T instance) {
        Function converter = instance.getConverter();
        Assertions.assertEquals((Object)true, converter.apply("Yes"));
        Assertions.assertEquals((Object)true, converter.apply("true"));
        Assertions.assertEquals((Object)true, converter.apply("1"));
        Assertions.assertEquals((Object)false, converter.apply("0"));
    }

    static Stream<Arguments> booleanToggleInstances() {
        return Stream.of(Arguments.of((Object[])new Object[]{new BooleanToggle("test", false)}), Arguments.of((Object[])new Object[]{new MyCustomBooleanToggle()}));
    }

    private static class MyCustomBooleanToggle
    extends BooleanToggle {
        protected MyCustomBooleanToggle() {
            super("my.custom.bool.toggle", false);
        }
    }
}

