/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.toggle;

import de.gematik.bbriccs.toggle.BooleanToggle;
import de.gematik.bbriccs.toggle.FeatureToggle;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public class FeatureConfiguration {
    public final boolean hasToggle(String key) {
        return this.getStringToggle(key).isPresent();
    }

    public final Optional<String> getStringToggle(String key) {
        return Optional.ofNullable(System.getProperty(key, System.getenv(key.toUpperCase().replace(".", "_"))));
    }

    public final String getStringToggle(String key, String defaultValue) {
        return this.getStringToggle(key).orElse(defaultValue);
    }

    public final boolean getBooleanToggle(String key) {
        return this.getToggle(BooleanToggle.forKey(key));
    }

    public final boolean getBooleanToggle(String key, boolean defaultValue) {
        return this.getToggle(BooleanToggle.forKey(key, defaultValue));
    }

    public final int getIntegerToggle(String key) {
        return this.getIntegerToggle(key, 0);
    }

    public final int getIntegerToggle(String key, int defaultValue) {
        return this.getToggle(key, value -> Integer.parseInt(value, 10), defaultValue);
    }

    public final double getDoubleToggle(String key) {
        return this.getDoubleToggle(key, 0.0);
    }

    public final double getDoubleToggle(String key, double defaultValue) {
        return this.getToggle(key, Double::parseDouble, defaultValue);
    }

    public final <T extends Enum<?>> T getEnumToggle(String key, Class<T> type, T defaultValue) {
        Function<String, Enum> converter = value -> Arrays.stream((Enum[])type.getEnumConstants()).filter(e -> e.name().equalsIgnoreCase((String)value)).findFirst().orElse(defaultValue);
        return (T)this.getToggle(key, converter, defaultValue);
    }

    public final <T> Optional<T> getToggle(String key, Function<String, T> converter) {
        return this.getStringToggle(key).map(converter);
    }

    public final <T> T getToggle(FeatureToggle<T> featureToggle) {
        return this.getToggle(featureToggle.getKey(), featureToggle.getConverter(), featureToggle.getDefaultValue());
    }

    public final <T> T getToggle(String key, Function<String, T> converter, T defaultValue) {
        return this.getToggle(key, converter).orElse(defaultValue);
    }
}

