/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.toggle;

import de.gematik.bbriccs.toggle.FeatureToggle;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;

public class BooleanToggle
implements FeatureToggle<Boolean> {
    private static final List<String> BOOL_TRUE_VALUES = List.of("yes", "1");
    private final String key;
    private final boolean defaultValue;

    protected BooleanToggle(String key, boolean defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    public Function<String, Boolean> getConverter() {
        return this::mapBoolean;
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    private boolean mapBoolean(String value) {
        if (BOOL_TRUE_VALUES.contains(value.toLowerCase())) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public static BooleanToggle forKey(String key) {
        return BooleanToggle.forKey(key, false);
    }

    public static BooleanToggle forKey(String key, boolean defaultValue) {
        return new BooleanToggle(key, defaultValue);
    }

    @Override
    @Generated
    public String getKey() {
        return this.key;
    }
}

