/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.toggle;

import de.gematik.bbriccs.toggle.FeatureConfiguration;
import de.gematik.bbriccs.toggle.FeatureToggle;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetSystemProperty;

class FeatureConfigurationTest {
    FeatureConfigurationTest() {
    }

    @Test
    void shouldNotHaveUndefinedToggles() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertFalse((boolean)fc.hasToggle("hello.world"));
        Assertions.assertEquals((Object)"Default Value", (Object)fc.getStringToggle("hello.world", "Default Value"));
    }

    @Test
    @SetSystemProperty(key="hello.world", value="Toggle Config")
    void shouldHaveSimpleToggle() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertTrue((boolean)fc.hasToggle("hello.world"));
        Assertions.assertEquals((Object)"Toggle Config", (Object)fc.getStringToggle("hello.world", "Default Value"));
    }

    @Test
    @SetSystemProperty(key="hello.boolean", value="Yes")
    void shouldHaveCustomBooleanToggleValue() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertTrue((boolean)fc.getBooleanToggle("hello.boolean"));
    }

    @Test
    @SetSystemProperty(key="hello.boolean", value="TRUE")
    void shouldHaveBooleanToggle() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertTrue((boolean)fc.getBooleanToggle("hello.boolean"));
    }

    @Test
    @SetSystemProperty(key="hello.boolean", value="False")
    void shouldHaveDefaultBooleanToggle() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertTrue((boolean)fc.getBooleanToggle("hello.boolean2", true));
    }

    @Test
    void shouldHaveDefaultBooleanToggleValue() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertFalse((boolean)fc.hasToggle("hello.boolean"));
        Assertions.assertFalse((boolean)fc.getBooleanToggle("hello.boolean2"));
    }

    @Test
    @SetSystemProperty(key="hello.integer", value="100")
    void shouldHaveIntegerToggle() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertEquals((int)100, (int)fc.getIntegerToggle("hello.integer"));
    }

    @Test
    void shouldHaveDefaultIntegerToggles() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertEquals((int)0, (int)fc.getIntegerToggle("hello.integer"));
        Assertions.assertEquals((int)10, (int)fc.getIntegerToggle("hello.integer", 10));
    }

    @Test
    @SetSystemProperty(key="hello.double", value="200.5")
    void shouldHaveDoubleToggle() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertEquals((double)200.5, (double)fc.getDoubleToggle("hello.double"));
    }

    @Test
    void shouldHaveDefaultDoubleToggles() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertEquals((double)0.0, (double)fc.getDoubleToggle("hello.double"));
        Assertions.assertEquals((double)10.1, (double)fc.getDoubleToggle("hello.double", 10.1));
    }

    @Test
    @SetSystemProperty(key="hello.enum", value="hello_world")
    void shouldMapToEnum() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertEquals((Object)((Object)TestToggle.HELLO_WORLD), (Object)fc.getEnumToggle("hello.enum", TestToggle.class, (Enum)TestToggle.TOGGLE_A));
    }

    @Test
    void shouldMapToDefaultEnum() {
        FeatureConfiguration fc = new FeatureConfiguration();
        Assertions.assertFalse((boolean)fc.hasToggle("hello.enum"));
        Assertions.assertEquals((Object)((Object)TestToggle.TOGGLE_A), (Object)fc.getEnumToggle("hello.enum", TestToggle.class, (Enum)TestToggle.TOGGLE_A));
    }

    @Test
    @SetSystemProperty(key="hello.enum", value="hello_world")
    void shouldMapFromFeatureToggle() {
        FeatureConfiguration fc = new FeatureConfiguration();
        TestFeatureToggle tft = new TestFeatureToggle();
        Assertions.assertTrue((boolean)fc.hasToggle("hello.enum"));
        Assertions.assertEquals((Object)((Object)TestToggle.HELLO_WORLD), (Object)fc.getToggle((FeatureToggle)tft));
    }

    @Test
    void shouldMapFromDefaultFeatureToggle() {
        FeatureConfiguration fc = new FeatureConfiguration();
        TestFeatureToggle tft = new TestFeatureToggle();
        Assertions.assertFalse((boolean)fc.hasToggle("hello.enum"));
        Assertions.assertEquals((Object)((Object)TestToggle.TOGGLE_B), (Object)fc.getToggle((FeatureToggle)tft));
    }

    public static enum TestToggle {
        TOGGLE_A,
        TOGGLE_B,
        HELLO_WORLD;

    }

    public static class TestFeatureToggle
    implements FeatureToggle<TestToggle> {
        public String getKey() {
            return "hello.enum";
        }

        public Function<String, TestToggle> getConverter() {
            return value -> TestToggle.valueOf(value.toUpperCase());
        }

        public TestToggle getDefaultValue() {
            return TestToggle.TOGGLE_B;
        }
    }
}

