/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.ValidationResultHelper;
import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.rest.HttpHeaderKey;
import de.gematik.bbriccs.rest.fd.MediaType;
import de.gematik.bbriccs.rest.fd.exceptions.UnexpectedResponseResourceError;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FhirBResponse<R extends Resource> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FhirBResponse.class);
    private final int statusCode;
    private final Duration duration;
    private final String usedJwt;
    private final List<HttpHeader> headers;
    @Nullable
    private final Resource resource;
    private final Class<R> expectedType;
    private final ValidationResult validationResult;

    private FhirBResponse(int statusCode, Duration duration, String usedJwt, List<HttpHeader> headers, ValidationResult validationResult, @Nullable Resource resource, Class<R> expectedType) {
        this.statusCode = statusCode;
        this.usedJwt = usedJwt;
        this.headers = headers;
        this.resource = resource;
        this.expectedType = expectedType;
        this.duration = duration;
        this.validationResult = validationResult;
    }

    public static <E extends Resource> FhirBResponseBuilder<E> forPayload(Class<E> expectType, @Nullable Resource resource) {
        return new FhirBResponseBuilder<E>(resource, expectType);
    }

    public boolean isValidPayload() {
        return this.validationResult.isSuccessful();
    }

    @Nullable
    public Resource getAsBaseResource() {
        return this.resource;
    }

    public OperationOutcome getAsOperationOutcome() {
        return this.getResourceAs(OperationOutcome.class);
    }

    public R getExpectedResource() {
        return this.getResourceAs(this.expectedType);
    }

    public <E extends RuntimeException> R getExpectedOrThrow(Function<FhirBResponse<? extends Resource>, E> errorFunction) {
        return (R)((Resource)this.getResourceOptional().orElseThrow(() -> (RuntimeException)errorFunction.apply(this)));
    }

    public Optional<R> getResourceOptional() {
        return this.getResourceOptional(this.expectedType);
    }

    private <U extends Resource> U getResourceAs(Class<U> clazz) {
        return (U)((Resource)this.getResourceOptional(clazz).orElseThrow(() -> new UnexpectedResponseResourceError(clazz, this.resource)));
    }

    public <U extends Resource> Optional<U> getResourceOptional(Class<U> clazz) {
        if (this.isResourceOfType(clazz)) {
            this.ensureValidationResult();
            return Optional.ofNullable(this.resource);
        }
        return Optional.empty();
    }

    public Class<? extends Resource> getResourceType() {
        if (this.resource != null) {
            return this.resource.getClass();
        }
        return EmptyResource.class;
    }

    public boolean isResourceOfType(Class<? extends Resource> clazz) {
        return clazz.equals(this.getResourceType());
    }

    public boolean isOfExpectedType() {
        return this.isResourceOfType(this.expectedType);
    }

    public boolean isOperationOutcome() {
        return OperationOutcome.class.equals(this.getResourceType());
    }

    public boolean isEmptyBody() {
        return this.getContentLength() == 0L;
    }

    public String getHeaderValue(HttpHeaderKey key) {
        return this.getHeaderValue(key.getKey());
    }

    public String getHeaderValue(String key) {
        return this.headers.stream().filter(header -> header.key().equalsIgnoreCase(key)).map(HttpHeader::value).findFirst().orElse("");
    }

    public MediaType getContentType() {
        return MediaType.fromString(this.getHeaderValue((HttpHeaderKey)StandardHttpHeaderKey.CONTENT_TYPE));
    }

    public long getContentLength() {
        String contentLengthHeader = this.getHeaderValue((HttpHeaderKey)StandardHttpHeaderKey.CONTENT_LENGTH);
        long contentLength = 0L;
        if (!contentLengthHeader.isBlank()) {
            contentLength = Long.parseLong(contentLengthHeader);
        }
        return contentLength;
    }

    public boolean isJson() {
        return this.getContentType() == MediaType.FHIR_JSON;
    }

    public boolean isXML() {
        return this.getContentType() == MediaType.FHIR_XML;
    }

    private void ensureValidationResult() {
        ValidationResultHelper.throwOnInvalidValidationResult(this.getResourceType(), (ValidationResult)this.validationResult);
    }

    public String toString() {
        String resourceType = this.getResourceType().getSimpleName();
        return MessageFormat.format("FdResponse(rc={0}, payloadType={1}, duration={2})", this.getStatusCode(), resourceType, this.duration.toMillis());
    }

    @Generated
    public int getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public Duration getDuration() {
        return this.duration;
    }

    @Generated
    public String getUsedJwt() {
        return this.usedJwt;
    }

    @Generated
    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    @Generated
    public Class<R> getExpectedType() {
        return this.expectedType;
    }

    @Generated
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public static class FhirBResponseBuilder<E extends Resource> {
        @Nullable
        private final Resource resource;
        private final Class<E> expectType;
        private int statusCode;
        private String usedJwt;
        private Duration duration = Duration.ZERO;
        private List<HttpHeader> headers = new LinkedList<HttpHeader>();

        public FhirBResponseBuilder<E> withStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public FhirBResponseBuilder<E> withDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public FhirBResponseBuilder<E> usedJwt(String jwt) {
            this.usedJwt = jwt;
            return this;
        }

        public FhirBResponseBuilder<E> withHeaders(List<HttpHeader> headers) {
            this.headers.addAll(headers);
            return this;
        }

        public FhirBResponse<E> andValidationResult(ValidationResult vr) {
            return new FhirBResponse<E>(this.statusCode, this.duration, this.usedJwt, this.headers, vr, this.resource, this.expectType);
        }

        @Generated
        private FhirBResponseBuilder(@Nullable Resource resource, Class<E> expectType) {
            this.resource = resource;
            this.expectType = expectType;
        }
    }
}

