/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.fhir.codec.exceptions.FhirCodecException;
import de.gematik.bbriccs.fhir.validation.DummyValidator;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import de.gematik.bbriccs.rest.HttpBClient;
import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.fd.FhirBRequest;
import de.gematik.bbriccs.rest.fd.FhirBResponse;
import de.gematik.bbriccs.rest.fd.FhirBaseBRequest;
import de.gematik.bbriccs.rest.fd.FhirClient;
import de.gematik.bbriccs.rest.fd.FhirClientImpl;
import de.gematik.bbriccs.rest.fd.MediaType;
import de.gematik.bbriccs.rest.fd.exceptions.UnsupportedMediaTypeException;
import de.gematik.bbriccs.rest.fd.plugins.BasicFhirHeaderProvider;
import de.gematik.bbriccs.rest.fd.plugins.FhirCodecObserver;
import de.gematik.bbriccs.rest.fd.plugins.FhirRequestHeaderProvider;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.JwtHeaderKey;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class FhirClientImplTest {
    FhirClientImplTest() {
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"EMPTY", "UNKNOWN"})
    void shouldFailOnBuildingWithUnsupportedMimeTypes(MediaType mt) {
        FhirClientImpl.FdClientBuilder fdcb = FhirClient.via(null);
        Assertions.assertThrows(UnsupportedMediaTypeException.class, () -> fdcb.usingFhirMimeType(mt));
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"FHIR_XML", "FHIR_JSON"})
    void shouldDecodeWithAcceptMime(MediaType mediaType) {
        String content = ResourceLoader.readFileFromResource((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        TestHttpClient httpClient = new TestHttpClient();
        FhirClient fdClient = FhirClient.via((HttpBClient)httpClient).usingDefaultFhir(false).acceptingUtf8Charset().usingFhirMimeType(mediaType).build();
        if (mediaType.isEquivalentTo(MediaType.FHIR_XML)) {
            Assertions.assertDoesNotThrow(() -> (Bundle)fdClient.decode(Bundle.class, content));
        } else {
            Assertions.assertThrows(FhirCodecException.class, () -> fdClient.decode(Bundle.class, content));
        }
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"APPLICATION_XML", "APPLICATION_JSON", "FHIR_XML", "FHIR_JSON"})
    void shouldValidateAnyContentType(MediaType mediaType) {
        String content = ResourceLoader.readFileFromResource((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        TestHttpClient httpClient = new TestHttpClient();
        FhirClient fdClient = FhirClient.via((HttpBClient)httpClient).usingDefaultFhir((ValidatorFhir)new DummyValidator(FhirContext.forR4())).acceptingUtf8Charset().usingMimeType(mediaType).build();
        Assertions.assertTrue((boolean)fdClient.isValid(content));
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"FHIR_XML", "FHIR_JSON"})
    void shouldSendRequestViaTestHttpClient(MediaType mediaType) {
        TestHttpClient httpClient = new TestHttpClient();
        FhirClient fdClient = FhirClient.via((HttpBClient)httpClient).usingDefaultFhir(false).acceptingUtf8Charset().usingFhirMimeType(mediaType).withHeaderProvider((FhirRequestHeaderProvider)BasicFhirHeaderProvider.simply(() -> JwtHeaderKey.AUTHORIZATION.createHeader("ABC"))).build();
        FhirBResponse response = (FhirBResponse)Assertions.assertDoesNotThrow(() -> fdClient.request((FhirBRequest)new TestFhirBRequest()));
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertEquals((int)1, (int)httpClient.requests.size());
        Assertions.assertEquals((Object)"Bearer ABC", (Object)httpClient.requests.get(0).headerValue(JwtHeaderKey.AUTHORIZATION.getKey()));
        Assertions.assertEquals((Object)"ABC", (Object)response.getUsedJwt());
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"FHIR_XML", "FHIR_JSON"})
    void shouldServeObservers(MediaType mediaType) {
        TestFhirCodecObserver observer = new TestFhirCodecObserver();
        TestHttpClient httpClient = new TestHttpClient();
        FhirClient fdClient = FhirClient.via((HttpBClient)httpClient).usingDefaultFhir(false).acceptingUtf8Charset().usingFhirMimeType(mediaType).registerForFhir((FhirCodecObserver)observer).withHeaderProvider((FhirRequestHeaderProvider)BasicFhirHeaderProvider.simply(HttpHeader::forCurrentDate)).build();
        FhirBResponse response = (FhirBResponse)Assertions.assertDoesNotThrow(() -> fdClient.request((FhirBRequest)new TestFhirBRequest()));
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertEquals((int)1, (int)httpClient.requests.size());
        Assertions.assertEquals((int)1, (int)observer.decodeCounter);
        Assertions.assertEquals((int)1, (int)observer.encodeCounter);
    }

    private static class TestHttpClient
    implements HttpBClient {
        private final List<HttpBRequest> requests = new LinkedList<HttpBRequest>();

        private TestHttpClient() {
        }

        public HttpBResponse send(HttpBRequest bRequest) {
            this.requests.add(bRequest);
            return HttpBResponse.status((int)200).withoutPayload();
        }
    }

    private static class TestFhirCodecObserver
    implements FhirCodecObserver {
        private int decodeCounter = 0;
        private int encodeCounter = 0;

        private TestFhirCodecObserver() {
        }

        public <E extends Resource, R extends Resource> void onDecode(Class<E> expectedType, String content, R resource) {
            ++this.decodeCounter;
        }

        public <R extends Resource> void onEncode(R resource, String content) {
            ++this.encodeCounter;
        }
    }

    private static class TestFhirBRequest
    extends FhirBaseBRequest<EmptyResource, EmptyResource> {
        protected TestFhirBRequest() {
            super(EmptyResource.class, HttpRequestMethod.GET, "/Task");
        }

        public EmptyResource getRequestBody() {
            return new EmptyResource();
        }
    }
}

