/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.fd.FhirGetBRequest;
import de.gematik.bbriccs.rest.fd.query.QueryParameter;
import de.gematik.bbriccs.rest.fd.query.SearchPrefix;
import de.gematik.bbriccs.rest.fd.query.SearchQueryParameter;
import java.util.List;
import org.hl7.fhir.r4.model.Task;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class FhirBaseBRequestTest {
    FhirBaseBRequestTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"task", "/task"})
    void shouldCalculatePath(String resource) {
        TestFhirGetBRequest01 tr = new TestFhirGetBRequest01(resource);
        Assertions.assertEquals((Object)HttpRequestMethod.GET, (Object)tr.getMethod());
        Assertions.assertEquals((Object)"/task", (Object)tr.getResourcePath());
        Assertions.assertEquals((Object)tr.getResourcePath(), (Object)tr.getRequestLocator());
        Assertions.assertTrue((boolean)tr.getHeaderParameters().isEmpty());
        Assertions.assertTrue((boolean)tr.getHeaders().isEmpty());
    }

    @Test
    void shouldCalculateLocatorWithQuery() {
        List<SearchQueryParameter> qp = List.of(new SearchQueryParameter("authoredOn", SearchPrefix.GE, "2023"), new SearchQueryParameter("updated", SearchPrefix.EQ, "2024"));
        TestFhirGetBRequest01 tr = new TestFhirGetBRequest01(qp);
        Assertions.assertEquals((Object)"/task", (Object)tr.getResourcePath());
        Assertions.assertEquals((Object)"/task?authoredOn=ge2023&updated=eq2024", (Object)tr.getRequestLocator());
    }

    @Test
    void shouldCalculateLocatorWithQueryAndId() {
        List<SearchQueryParameter> qp = List.of(new SearchQueryParameter("authoredOn", SearchPrefix.GE, "2023"), new SearchQueryParameter("updated", SearchPrefix.EQ, "2024"));
        TestFhirGetBRequest01 tr = new TestFhirGetBRequest01("890567", qp);
        Assertions.assertEquals((Object)"/task/890567", (Object)tr.getResourcePath());
        Assertions.assertEquals((Object)"/task/890567?authoredOn=ge2023&updated=eq2024", (Object)tr.getRequestLocator());
        Assertions.assertEquals(EmptyResource.class, tr.getRequestBody().getClass());
    }

    private static class TestFhirGetBRequest01
    extends FhirGetBRequest<Task> {
        protected TestFhirGetBRequest01(String fhirResource) {
            super(Task.class, fhirResource);
        }

        protected TestFhirGetBRequest01(List<QueryParameter> qp) {
            super(Task.class, "/task", null, qp);
        }

        protected TestFhirGetBRequest01(String resourceId, List<QueryParameter> qp) {
            super(Task.class, "/task", resourceId, qp);
        }
    }
}

