/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.codec.FhirCodec;
import de.gematik.bbriccs.fhir.codec.exceptions.FhirCodecException;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.fd.FdRequest;
import de.gematik.bbriccs.rest.fd.FdResponse;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import lombok.Generated;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FdResponseCreator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FdResponseCreator.class);
    private final FhirCodec fhir;
    private final BiFunction<Class<? extends Resource>, String, Resource> decoder;

    public FdResponseCreator(FhirCodec fhir, BiFunction<Class<? extends Resource>, String, Resource> decoder) {
        this.fhir = fhir;
        this.decoder = decoder;
    }

    public <T extends Resource, R extends Resource> FdResponseBuilder<R> takeExpectationFrom(FdRequest<T, R> request) {
        return this.expecting(request.expectedResponseType());
    }

    public <R extends Resource> FdResponseBuilder<R> expecting(Class<R> expectResponseType) {
        return new FdResponseBuilder<R>(this.fhir, this.decoder, expectResponseType);
    }

    public static class FdResponseBuilder<R extends Resource> {
        private final FhirCodec fhir;
        private final BiFunction<Class<? extends Resource>, String, Resource> decoder;
        private final Class<R> expectResponseType;
        @Nullable
        private String usedAccessToken;
        @Nullable
        private HttpBResponse httpResponse;

        public FdResponseBuilder<R> usedAccessToken(String accessToken) {
            this.usedAccessToken = accessToken;
            return this;
        }

        public FdResponseBuilder<R> received(HttpBResponse httpResponse) {
            this.httpResponse = httpResponse;
            return this;
        }

        public FdResponse<R> withoutDuration() {
            return this.withDuration(Duration.ZERO);
        }

        public FdResponse<R> withDuration(Duration duration) {
            Objects.requireNonNull(this.usedAccessToken, "No AccessToken which was used for the Request provided");
            Objects.requireNonNull(this.httpResponse, "No HTTP-Response provided");
            if (this.httpResponse.statusCode() >= 500) {
                log.error(MessageFormat.format("Server Error {0}: {1}", this.httpResponse.statusCode(), this.httpResponse.bodyAsString()));
            }
            ValidationResult vr = this.validateContent(this.httpResponse.bodyAsString());
            Resource resource = this.decode(this.httpResponse.bodyAsString(), this.expectResponseType);
            return FdResponse.forPayload(this.expectResponseType, resource).withStatusCode(this.httpResponse.statusCode()).withDuration(duration).usedJwt(this.usedAccessToken).withHeaders(this.httpResponse.headers()).andValidationResult(vr);
        }

        private Resource decode(String content, Class<? extends Resource> expect) {
            Resource ret;
            log.trace("Try to decode FHIR Content as {}\n{}", (Object)expect.getSimpleName(), (Object)content);
            try {
                ret = this.decoder.apply(expect, content);
            }
            catch (DataFormatException | FhirCodecException | IllegalArgumentException e) {
                log.info(MessageFormat.format("Given content of length {0} could not be decoded as {1}, try without expectation", content.length(), expect.getSimpleName()));
                ret = this.decoder.apply(null, content);
            }
            return ret;
        }

        private ValidationResult validateContent(String content) {
            ValidationResult vr;
            if (content.isEmpty() || content.isBlank()) {
                vr = new ValidationResult(this.fhir.getContext(), List.of());
            } else {
                vr = this.fhir.validate(content);
                if (!vr.isSuccessful()) {
                    log.error(MessageFormat.format("FHIR Content is invalid\n{0}", content));
                }
            }
            return vr;
        }

        @Generated
        private FdResponseBuilder(FhirCodec fhir, BiFunction<Class<? extends Resource>, String, Resource> decoder, Class<R> expectResponseType) {
            this.fhir = fhir;
            this.decoder = decoder;
            this.expectResponseType = expectResponseType;
        }
    }
}

