/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.codec.FhirCodec;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import de.gematik.bbriccs.fhir.validation.ValidatorFhirFactory;
import de.gematik.bbriccs.rest.HttpBClient;
import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.fd.FdRequest;
import de.gematik.bbriccs.rest.fd.FdResponse;
import de.gematik.bbriccs.rest.fd.FdResponseCreator;
import de.gematik.bbriccs.rest.fd.MediaType;
import de.gematik.bbriccs.rest.fd.exceptions.UnsupportedMediaTypeException;
import de.gematik.bbriccs.rest.fd.plugins.FhirCodecObserver;
import de.gematik.bbriccs.rest.fd.plugins.FhirCodecObserverManager;
import de.gematik.bbriccs.rest.fd.plugins.FhirDecoderObserver;
import de.gematik.bbriccs.rest.fd.plugins.FhirEncoderObserver;
import de.gematik.bbriccs.rest.fd.plugins.RequestHeaderProvider;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hl7.fhir.r4.model.Resource;

public class FdClient {
    private final HttpBClient httpClient;
    private final FhirCodec fhir;
    private final FdResponseCreator responseCreator;
    private final List<RequestHeaderProvider> headerProviders;
    private final String acceptCharset;
    private final MediaType acceptMime;
    private final MediaType sendMime;
    private final EncodingType encodingType;
    private final EncodingType decodingType;
    private final FhirCodecObserverManager fhirObserver;

    private FdClient(FdClientBuilder builder) {
        this.httpClient = Objects.requireNonNull(builder.httpClient, "FdClient is missing underlying HTTP-transport");
        this.fhir = Objects.requireNonNull(builder.fhir, "FdClient is missing FHIR-Codec");
        this.acceptCharset = Objects.requireNonNull(builder.acceptCharset, "FdClient is missing Accept-Charset");
        this.acceptMime = Objects.requireNonNull(builder.acceptMime, "FdClient is missing Accept-Mime-Type");
        this.sendMime = Objects.requireNonNull(builder.sendMime, "FdClient is missing Send-Mime-Type");
        this.responseCreator = new FdResponseCreator(this.fhir, this::decode);
        this.headerProviders = builder.headerProviders;
        this.encodingType = this.sendMime.toFhirEncoding();
        this.decodingType = this.acceptMime.toFhirEncoding();
        this.fhirObserver = builder.fhirObserverBuilder.build();
    }

    public <R extends Resource> String encode(R resource) {
        return this.encode(resource, false);
    }

    public <R extends Resource> String encode(R resource, boolean prettyPrint) {
        String ret = this.fhir.encode(resource, this.encodingType, prettyPrint);
        this.fhirObserver.serveEncoderObservers(resource, ret);
        return ret;
    }

    public <R extends Resource> R decode(Class<R> type, String content) {
        Resource ret = this.fhir.decode(type, content, this.decodingType);
        this.fhirObserver.serveDecoderObservers(type, content, ret);
        return (R)ret;
    }

    public boolean isValid(String content) {
        return this.validate(content).isSuccessful();
    }

    public ValidationResult validate(String content) {
        return this.fhir.validate(content);
    }

    public <T extends Resource, R extends Resource> FdResponse<R> request(FdRequest<T, R> request) {
        String body = this.encode((R)request.getRequestBody());
        List<HttpHeader> httpHeaders = this.initHeaders();
        httpHeaders.addAll(request.getHeaders());
        this.headerProviders.forEach(provider -> httpHeaders.add(provider.forRequest(request)));
        HttpBRequest httpRequest = new HttpBRequest(request.getMethod(), request.getRequestLocator(), httpHeaders, body);
        Instant start = Instant.now();
        HttpBResponse httpResponse = this.httpClient.send(httpRequest);
        Duration duration = Duration.between(start, Instant.now());
        String idpToken = httpRequest.getBearerToken().orElse("n/a");
        return this.responseCreator.takeExpectationFrom(request).usedAccessToken(idpToken).received(httpResponse).withDuration(duration);
    }

    private List<HttpHeader> initHeaders() {
        LinkedList<HttpHeader> headers = new LinkedList<HttpHeader>();
        headers.add(StandardHttpHeaderKey.ACCEPT_CHARSET.createHeader(this.acceptCharset));
        headers.add(StandardHttpHeaderKey.ACCEPT.createHeader(this.acceptMime.asString()));
        headers.add(StandardHttpHeaderKey.CONTENT_TYPE.createHeader(this.sendMime.asString()));
        return headers;
    }

    public static FdClientBuilder via(HttpBClient httpClient) {
        return new FdClientBuilder(httpClient);
    }

    @Generated
    public FhirCodec getFhir() {
        return this.fhir;
    }

    public static class FdClientBuilder {
        private final HttpBClient httpClient;
        private final List<RequestHeaderProvider> headerProviders = new LinkedList<RequestHeaderProvider>();
        private final FhirCodecObserverManager.FhirObserverBuilder fhirObserverBuilder = new FhirCodecObserverManager.FhirObserverBuilder();
        private FhirCodec fhir;
        private String acceptCharset = "utf-8";
        private MediaType acceptMime;
        private MediaType sendMime;

        private FdClientBuilder(HttpBClient httpClient) {
            this.httpClient = httpClient;
        }

        public FdClientBuilder usingFhir(FhirCodec fhir) {
            this.fhir = fhir;
            return this;
        }

        public FdClientBuilder usingDefaultFhir(boolean withValidation) {
            if (withValidation) {
                return this.usingDefaultFhir(ValidatorFhirFactory.createValidator());
            }
            return this.usingFhir(FhirCodec.forR4().andDummyValidator());
        }

        public FdClientBuilder usingDefaultFhir(ValidatorFhir fhirValidator) {
            return this.usingFhir(FhirCodec.forR4().andCustomValidator(fhirValidator));
        }

        public FdClientBuilder acceptingUtf8Charset() {
            return this.acceptingCharset("utf-8");
        }

        public FdClientBuilder acceptingCharset(String acceptCharset) {
            this.acceptCharset = acceptCharset;
            return this;
        }

        public FdClientBuilder acceptMimeType(MediaType mimeType) {
            this.acceptMime = mimeType;
            return this;
        }

        public FdClientBuilder sendMimeType(MediaType mimeType) {
            this.sendMime = mimeType;
            return this;
        }

        public FdClientBuilder usingMimeType(MediaType mimeType) {
            return this.sendMimeType(mimeType).acceptMimeType(mimeType);
        }

        public FdClientBuilder usingFhirMimeType(MediaType mimeType) {
            return switch (mimeType) {
                case MediaType.ACCEPT_FHIR_XML, MediaType.FHIR_XML -> this.sendMimeType(MediaType.FHIR_XML).acceptMimeType(MediaType.ACCEPT_FHIR_XML);
                case MediaType.ACCEPT_FHIR_JSON, MediaType.FHIR_JSON -> this.sendMimeType(MediaType.FHIR_JSON).acceptMimeType(MediaType.ACCEPT_FHIR_JSON);
                default -> throw new UnsupportedMediaTypeException(mimeType);
            };
        }

        public FdClientBuilder withHeaderProvider(RequestHeaderProvider provider) {
            this.headerProviders.add(provider);
            return this;
        }

        public FdClientBuilder registerForFhirEncode(FhirEncoderObserver feo) {
            this.fhirObserverBuilder.registerForEncode(feo);
            return this;
        }

        public FdClientBuilder registerForFhirDecode(FhirDecoderObserver fdo) {
            this.fhirObserverBuilder.registerForDecode(fdo);
            return this;
        }

        public FdClientBuilder registerForFhir(FhirCodecObserver fco) {
            return this.registerForFhirDecode(fco).registerForFhirEncode(fco);
        }

        public FdClient build() {
            return new FdClient(this);
        }
    }
}

