/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.exceptions.UnsupportedEncodingException;
import de.gematik.bbriccs.rest.fd.MediaType;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MediaTypeTest {
    private final List<String> jsonTypes = List.of("application/fhir+json; fhirVersion=4.0; charset=utf-8", "application/fhir+json; fhirVersion=4.0", "application/fhir+json; charset=utf-8", "application/fhir+json;fhirVersion=4.0;charset=utf-8", "application/fhir+json;fhirVersion=4.0", "application/fhir+json;charset=utf-8", "application/fhir+json", "APPLICATION/FHIR+JSON");
    private final List<String> xmlTypes = List.of("application/fhir+xml; fhirVersion=4.0; charset=utf-8", "application/fhir+xml; fhirVersion=4.0", "application/fhir+xml; charset=utf-8", "application/fhir+xml;fhirVersion=4.0;charset=utf-8", "application/fhir+xml;fhirVersion=4.0", "application/fhir+xml;charset=utf-8", "application/fhir+xml", "APPLICATION/FHIR+XML");
    private final List<String> unknownTypes = List.of("*/*", "application/json", "application/xml", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "text/html", "text/xml", "text/plain", "charset=utf-8;application/fhir+json", "charset=utf-8;application/fhir+xml");

    MediaTypeTest() {
    }

    @Test
    void fromStringJson() {
        for (String s : this.jsonTypes) {
            MediaType expected = MediaType.FHIR_JSON;
            MediaType actual = MediaType.fromString((String)s);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void fromStringXml() {
        for (String s : this.xmlTypes) {
            MediaType expected = MediaType.FHIR_XML;
            MediaType actual = MediaType.fromString((String)s);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void fromStringUnknown() {
        for (String s : this.unknownTypes) {
            MediaType expected = MediaType.UNKNOWN;
            MediaType actual = MediaType.fromString((String)s);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void fromStringEmpty() {
        List<String> inputs = Arrays.asList("", null);
        inputs.forEach(s -> {
            MediaType expected = MediaType.EMPTY;
            MediaType actual = MediaType.fromString((String)s);
            Assertions.assertEquals((Object)expected, (Object)actual);
        });
    }

    @Test
    void comparisonJson() {
        this.jsonTypes.forEach(typeString -> {
            MediaType expectedPlain = MediaType.FHIR_JSON;
            MediaType expectedAccept = MediaType.ACCEPT_FHIR_JSON;
            MediaType actual = MediaType.fromString((String)typeString);
            Assertions.assertTrue((boolean)actual.isEquivalentTo(expectedPlain));
            Assertions.assertTrue((boolean)actual.isEquivalentTo(expectedAccept));
        });
    }

    @Test
    void comparisonXml() {
        this.xmlTypes.forEach(typeString -> {
            MediaType expectedPlain = MediaType.FHIR_XML;
            MediaType expectedAccept = MediaType.ACCEPT_FHIR_XML;
            MediaType actual = MediaType.fromString((String)typeString);
            Assertions.assertTrue((boolean)actual.isEquivalentTo(expectedPlain));
            Assertions.assertTrue((boolean)actual.isEquivalentTo(expectedAccept));
        });
    }

    @Test
    void asStringXml() {
        String mt1 = MediaType.ACCEPT_FHIR_XML.asString();
        String exp1 = "application/fhir+xml;q=1.0, application/xml+fhir;q=0.9";
        Assertions.assertEquals((Object)"application/fhir+xml;q=1.0, application/xml+fhir;q=0.9", (Object)mt1);
        Assertions.assertEquals((Object)"application/fhir+xml;q=1.0, application/xml+fhir;q=0.9", (Object)mt1.toString());
        String mt2 = MediaType.ACCEPT_FHIR_XML.asString(true);
        String exp2 = "application/fhir+xml";
        Assertions.assertEquals((Object)"application/fhir+xml", (Object)mt2);
        String mt3 = MediaType.ACCEPT_FHIR_XML.asString(true, true);
        String exp3 = "fhir+xml";
        Assertions.assertEquals((Object)"fhir+xml", (Object)mt3);
    }

    @Test
    void asStringJson() {
        String mt1 = MediaType.ACCEPT_FHIR_JSON.asString();
        String exp1 = "application/fhir+json;q=1.0, application/json+fhir;q=0.9";
        Assertions.assertEquals((Object)"application/fhir+json;q=1.0, application/json+fhir;q=0.9", (Object)mt1);
        String mt2 = MediaType.ACCEPT_FHIR_JSON.asString(true);
        String exp2 = "application/fhir+json";
        Assertions.assertEquals((Object)"application/fhir+json", (Object)mt2);
        String mt3 = MediaType.ACCEPT_FHIR_JSON.asString(true, true);
        String exp3 = "fhir+json";
        Assertions.assertEquals((Object)"fhir+json", (Object)mt3);
    }

    @Test
    void toFhirEncodingJson() {
        List<MediaType> mediaTypes = List.of(MediaType.FHIR_JSON, MediaType.ACCEPT_FHIR_JSON);
        mediaTypes.forEach(mt -> {
            EncodingType encoding = mt.toFhirEncoding();
            Assertions.assertEquals((Object)EncodingType.JSON, (Object)encoding);
        });
    }

    @Test
    void toFhirEncodingXml() {
        List<MediaType> mediaTypes = List.of(MediaType.FHIR_XML, MediaType.ACCEPT_FHIR_XML);
        mediaTypes.forEach(mt -> {
            EncodingType encoding = mt.toFhirEncoding();
            Assertions.assertEquals((Object)EncodingType.XML, (Object)encoding);
        });
    }

    @Test
    void shouldThrowOnInvalidFhirEncoding() {
        List<MediaType> mediaType = List.of(MediaType.EMPTY, MediaType.UNKNOWN);
        mediaType.forEach(mt -> Assertions.assertThrows(UnsupportedEncodingException.class, () -> ((MediaType)mt).toFhirEncoding()));
    }
}

