/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.fhir.codec.utils.FhirTestResourceUtil;
import de.gematik.bbriccs.rest.fd.FdResponse;
import de.gematik.bbriccs.rest.fd.exceptions.UnexpectedResponseResourceError;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class FdResponseTest {
    FdResponseTest() {
    }

    @Test
    void shouldProvideEmptyResourceOnNullBody() {
        FdResponse response = FdResponse.forPayload(Bundle.class, null).andValidationResult(null);
        Assertions.assertEquals(EmptyResource.class, (Object)response.getResourceType());
    }

    @Test
    void shouldThrowOnUnexpectedNullResource() {
        FdResponse response = FdResponse.forPayload(Bundle.class, null).andValidationResult(null);
        UnexpectedResponseResourceError exception = (UnexpectedResponseResourceError)Assertions.assertThrows(UnexpectedResponseResourceError.class, () -> ((FdResponse)response).getExpectedResource());
        Assertions.assertTrue((boolean)exception.getMessage().contains("of type Bundle but received NULL"));
    }

    @Test
    void shouldDetectUnexpectedOperationOutcome() {
        FdResponse response = FdResponse.forPayload(Bundle.class, (Resource)FhirTestResourceUtil.createOperationOutcome()).andValidationResult(null);
        UnexpectedResponseResourceError exception = (UnexpectedResponseResourceError)Assertions.assertThrows(UnexpectedResponseResourceError.class, () -> ((FdResponse)response).getExpectedResource());
        Assertions.assertTrue((boolean)exception.getMessage().contains("of type Bundle but received OperationOutcome"));
    }

    @Test
    void shouldProvideCorrectResourceTypeRegardlessOfExpectation() {
        FdResponse response = FdResponse.forPayload(Bundle.class, (Resource)new Task()).andValidationResult(null);
        Assertions.assertEquals(Task.class, (Object)response.getResourceType());
    }

    @ParameterizedTest
    @MethodSource
    void shouldProvideContentLength(HttpHeader contentLength) {
        FdResponse response = FdResponse.forPayload(Bundle.class, (Resource)new Task()).withHeaders(List.of(contentLength)).andValidationResult(null);
        Assertions.assertEquals((long)0L, (long)response.getContentLength());
    }

    static Stream<Arguments> shouldProvideContentLength() {
        return Stream.of(StandardHttpHeaderKey.CONTENT_LENGTH.createHeader(""), StandardHttpHeaderKey.CONTENT_LENGTH.createHeader(" "), StandardHttpHeaderKey.CONTENT_TYPE.createHeader("application/json")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldThrowCustomExceptionOnUnexpected(Resource resource) {
        FdResponse response = FdResponse.forPayload(Task.class, (Resource)resource).withStatusCode(200).andValidationResult(FhirTestResourceUtil.createEmptyValidationResult());
        Function<FdResponse, RuntimeException> errorFunction = r -> new RuntimeException("test");
        Assertions.assertThrows(RuntimeException.class, () -> response.getExpectedOrThrow(errorFunction));
    }

    static Stream<Arguments> shouldThrowCustomExceptionOnUnexpected() {
        return Stream.of(new Bundle(), FhirTestResourceUtil.createOperationOutcome()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @Test
    void shouldNotThrowOnExpectedResource() {
        Bundle resource = new Bundle();
        FdResponse response = FdResponse.forPayload(Bundle.class, (Resource)resource).withStatusCode(200).andValidationResult(FhirTestResourceUtil.createEmptyValidationResult());
        Function<FdResponse, RuntimeException> errorFunction = r -> new RuntimeException("test");
        Bundle r2 = (Bundle)Assertions.assertDoesNotThrow(() -> (Bundle)response.getExpectedOrThrow(errorFunction));
        Assertions.assertEquals((Object)r2, (Object)resource);
    }
}

