/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.exceptions.UnsupportedEncodingException;
import java.text.MessageFormat;

public enum MediaType {
    ACCEPT_FHIR_XML("application/fhir+xml;q=1.0, application/xml+fhir;q=0.9"),
    FHIR_XML("application/fhir+xml"),
    ACCEPT_FHIR_JSON("application/fhir+json;q=1.0, application/json+fhir;q=0.9"),
    FHIR_JSON("application/fhir+json"),
    APPLICATION_JSON("application/json"),
    APPLICATION_XML("application/xml"),
    EMPTY(""),
    UNKNOWN("*/*");

    private String stringValue;

    private MediaType(String stringValue) {
        this.stringValue = stringValue;
    }

    public String asString() {
        return this.asString(false);
    }

    public String asString(boolean removeParameters) {
        return this.asString(removeParameters, false);
    }

    public String asString(boolean removeParameters, boolean removeApplication) {
        String ret = removeParameters ? this.stringValue.split(";")[0] : this.stringValue;
        if (removeApplication) {
            ret = ret.replace("application/", "");
        }
        return ret.toLowerCase();
    }

    public EncodingType toFhirEncoding() {
        return switch (this) {
            case FHIR_XML, ACCEPT_FHIR_XML, APPLICATION_XML -> EncodingType.XML;
            case FHIR_JSON, ACCEPT_FHIR_JSON, APPLICATION_JSON -> EncodingType.JSON;
            default -> throw new UnsupportedEncodingException(MessageFormat.format("MediaType {0} cannot be translated to proper FHIR encoding", this.asString()));
        };
    }

    public static MediaType fromString(String stringValue) {
        MediaType mediaType;
        if (stringValue == null || stringValue.isEmpty()) {
            return EMPTY;
        }
        String[] tokens = stringValue.split(";");
        String mts = tokens[0].toLowerCase();
        if (mts.contains(FHIR_XML.asString())) {
            mediaType = FHIR_XML;
        } else if (mts.contains(FHIR_JSON.asString())) {
            mediaType = FHIR_JSON;
        } else {
            mediaType = UNKNOWN;
            mediaType.stringValue = stringValue;
        }
        return mediaType;
    }

    public boolean isEquivalentTo(MediaType other) {
        String myMts = this.stringValue.split(";")[0].toLowerCase();
        String otherMts = other.stringValue.split(";")[0].toLowerCase();
        return myMts.equals(otherMts);
    }

    public String toString() {
        return this.stringValue;
    }
}

