/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd.plugins;

import de.gematik.bbriccs.rest.fd.plugins.FhirCodecObserver;
import de.gematik.bbriccs.rest.fd.plugins.FhirCodecObserverManager;
import de.gematik.bbriccs.rest.fd.plugins.FhirDecoderObserver;
import de.gematik.bbriccs.rest.fd.plugins.FhirEncoderObserver;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FhirCodecObserverManagerTest {
    FhirCodecObserverManagerTest() {
    }

    @Test
    void shouldNotifyFhirCodecObservers() {
        TestFhirCodecObserver observer = new TestFhirCodecObserver();
        FhirCodecObserverManager observerManager = new FhirCodecObserverManager.FhirObserverBuilder().registerForDecode((FhirDecoderObserver)observer).registerForEncode((FhirEncoderObserver)observer).build();
        observerManager.serveDecoderObservers(Bundle.class, "", (Resource)new Bundle());
        observerManager.serveEncoderObservers((Resource)new Bundle(), "");
        Assertions.assertEquals((int)1, (int)observer.decodeCounter);
        Assertions.assertEquals((int)1, (int)observer.encodeCounter);
    }

    private static class TestFhirCodecObserver
    implements FhirCodecObserver {
        private int decodeCounter = 0;
        private int encodeCounter = 0;

        private TestFhirCodecObserver() {
        }

        public <E extends Resource, R extends Resource> void onDecode(Class<E> expectedType, String content, R resource) {
            ++this.decodeCounter;
        }

        public <R extends Resource> void onEncode(R resource, String content) {
            ++this.encodeCounter;
        }
    }
}

