/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.fhir.codec.FhirCodec;
import de.gematik.bbriccs.fhir.codec.utils.FhirTestResourceUtil;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.fd.FdBaseRequest;
import de.gematik.bbriccs.rest.fd.FdRequest;
import de.gematik.bbriccs.rest.fd.FdResponse;
import de.gematik.bbriccs.rest.fd.FdResponseCreator;
import de.gematik.bbriccs.rest.fd.MediaType;
import de.gematik.bbriccs.rest.fd.exceptions.UnexpectedResponseResourceError;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

class FdResponseCreatorTest {
    private static FhirCodec fhir;
    private static FdResponseCreator responseCreator;
    private static final List<HttpHeader> HEADERS_JSON;
    private static final String PROTOCOL = "HTTP/1.1";
    private static final String testToken = "eyJhbGciOiJCUDI1NlIxIiwidHlwIjoiYXQrSldUIiwia2lkIjoicHVrX2lkcF9zaWcifQ.eyJzdWIiOiJJWERkLTNyUVpLS0ZYVWR4R0dqNFBERG9WNk0wUThaai1xdzF2cjF1XzU4IiwicHJvZmVzc2lvbk9JRCI6IjEuMi4yNzYuMC43Ni40LjQ5Iiwib3JnYW5pemF0aW9uTmFtZSI6ImdlbWF0aWsgTXVzdGVya2Fzc2UxR0tWTk9ULVZBTElEIiwiaWROdW1tZXIiOiJYMTEwNTAyNDE0IiwiYW1yIjpbIm1mYSIsInNjIiwicGluIl0sImlzcyI6Imh0dHA6Ly9sb2NhbGhvc3Q6NTUwMTEvYXV0aC9yZWFsbXMvaWRwLy53ZWxsLWtub3duL29wZW5pZC1jb25maWd1cmF0aW9uIiwiZ2l2ZW5fbmFtZSI6IlJvYmluIEdyYWYiLCJjbGllbnRfaWQiOiJlcnAtdGVzdHN1aXRlLWZkIiwiYWNyIjoiZ2VtYXRpay1laGVhbHRoLWxvYS1oaWdoIiwiYXVkIjoiaHR0cDovL2xvY2FsaG9zdDozMDAwLyIsImF6cCI6ImVycC10ZXN0c3VpdGUtZmQiLCJzY29wZSI6Im9wZW5pZCBlLXJlemVwdCIsImF1dGhfdGltZSI6MTY0MzgwNDczMywiZXhwIjoxNjQzODA1MDMzLCJmYW1pbHlfbmFtZSI6IlbDs3Jtd2lua2VsIiwiaWF0IjoxNjQzODA0NjEzLCJqdGkiOiI2Yjg3NmU0MWNmMGViNGJkIn0.MV5cDnL3JBZ4b6xr9SqiYDmZ7qtZFEWBd1vCrHzVniZeDhkyuSYc7xhf577h2S21CzNgrMp0M6JALNW9Qjnw_g";

    FdResponseCreatorTest() {
    }

    @BeforeAll
    static void setUp() {
        fhir = FhirCodec.forR4().andNonProfiledValidator();
        responseCreator = new FdResponseCreator(fhir, (expect, content) -> fhir.decode(expect, content));
    }

    private String encodeTestRessource(Resource resource, EncodingType type) {
        return fhir.encode((IBaseResource)resource, type);
    }

    @ParameterizedTest
    @MethodSource
    void deserializeResourceResponses(String filePath, Class<? extends Resource> resourceType) {
        String content = ResourceLoader.readFileFromResource((String)filePath);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 200, HEADERS_JSON, content);
        FdResponse response = responseCreator.expecting(resourceType).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Resource auditEvent = response.getAsBaseResource();
        Assertions.assertNotNull((Object)auditEvent, (String)MessageFormat.format("Response must contain a Resource of Type {0}", resourceType));
        Assertions.assertDoesNotThrow(() -> ((FdResponse)response).getExpectedResource());
    }

    static Stream<Arguments> deserializeResourceResponses() {
        return Stream.of(Arguments.of((Object[])new Object[]{"examples/fhir/valid/hl7/patient/patient_01.xml", Patient.class}), Arguments.of((Object[])new Object[]{"examples/fhir/valid/erp/kbv/1.1.0/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml", Bundle.class}));
    }

    @Test
    void unexpectedOperationOutcomeResponse() {
        String testOperationOutcome = this.encodeTestRessource((Resource)FhirTestResourceUtil.createOperationOutcome(), EncodingType.JSON);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 404, HEADERS_JSON, testOperationOutcome);
        FdResponse response = responseCreator.expecting(OperationOutcome.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Resource resource = response.getAsBaseResource();
        Assertions.assertNotNull((Object)resource, (String)MessageFormat.format("Response must contain a Resource of Type {0}", OperationOutcome.class));
        Assertions.assertInstanceOf(OperationOutcome.class, (Object)resource, (String)"Resource is expected to be OperationOutcome");
        Assertions.assertTrue((boolean)response.isOfExpectedType());
        OperationOutcome concreteResource = response.getAsOperationOutcome();
        Assertions.assertNotNull((Object)concreteResource, (String)MessageFormat.format("Resource must be castable to Type {0}", OperationOutcome.class));
    }

    @Test
    void expectedOperationOutcome() {
        String testOperationOutcome = this.encodeTestRessource((Resource)FhirTestResourceUtil.createOperationOutcome(), EncodingType.JSON);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 404, HEADERS_JSON, testOperationOutcome);
        FdResponse response = responseCreator.expecting(OperationOutcome.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Resource outputOO = response.getAsBaseResource();
        Assertions.assertNotNull((Object)outputOO, (String)MessageFormat.format("Response must contain a Resource of Type {0}", OperationOutcome.class));
        Assertions.assertInstanceOf(OperationOutcome.class, (Object)outputOO, (String)"Resource is expected to be OperationOutcome");
        OperationOutcome concreteResource = (OperationOutcome)response.getExpectedResource();
        Assertions.assertNotNull((Object)concreteResource, (String)MessageFormat.format("Resource must be castable to Type {0}", OperationOutcome.class));
    }

    @ParameterizedTest
    @MethodSource(value={"deserializeResourceResponses"})
    void shouldReceiveResourceAlthoughOperationOutcomeExpected(String filePath, Class<? extends Resource> resourceType) {
        String content = ResourceLoader.readFileFromResource((String)filePath);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 201, HEADERS_JSON, content);
        FdResponse response = responseCreator.expecting(OperationOutcome.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertFalse((boolean)response.isResourceOfType(OperationOutcome.class));
        Assertions.assertTrue((boolean)response.isResourceOfType(resourceType));
    }

    @Test
    void shouldFetchUnexpectedResponseResource01() {
        String testOperationOutcome = this.encodeTestRessource((Resource)FhirTestResourceUtil.createOperationOutcome(), EncodingType.JSON);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 404, HEADERS_JSON, testOperationOutcome);
        FdResponse response = responseCreator.expecting(AuditEvent.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertThrows(UnexpectedResponseResourceError.class, () -> ((FdResponse)response).getExpectedResource());
    }

    @ParameterizedTest
    @MethodSource(value={"deserializeResourceResponses"})
    void shouldFetchUnexpectedResponseResource02(String filePath, Class<? extends Resource> resourceType) {
        String content = ResourceLoader.readFileFromResource((String)filePath);
        Class<Task> expectation = Task.class;
        Assertions.assertNotEquals(resourceType, expectation);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 204, HEADERS_JSON, content);
        FdResponse response = responseCreator.expecting(expectation).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertThrows(UnexpectedResponseResourceError.class, () -> ((FdResponse)response).getExpectedResource());
    }

    @Test
    void fetchUnexpectedResponseResourceOptional() {
        String testOperationOutcome = this.encodeTestRessource((Resource)FhirTestResourceUtil.createOperationOutcome(), EncodingType.JSON);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 404, HEADERS_JSON, testOperationOutcome);
        FdResponse response = responseCreator.expecting(AuditEvent.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Optional resource = response.getResourceOptional();
        Assertions.assertTrue((boolean)resource.isEmpty());
    }

    @Test
    void shouldIdentifyConcreteResourceOfType() {
        String testOperationOutcome = this.encodeTestRessource((Resource)FhirTestResourceUtil.createOperationOutcome(), EncodingType.JSON);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 404, HEADERS_JSON, testOperationOutcome);
        FdResponse response = responseCreator.expecting(AuditEvent.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertTrue((boolean)response.isResourceOfType(OperationOutcome.class));
        Assertions.assertFalse((boolean)response.isResourceOfType(AuditEvent.class));
        Assertions.assertTrue((boolean)response.isOperationOutcome());
        Assertions.assertThrows(UnexpectedResponseResourceError.class, () -> ((FdResponse)response).getExpectedResource());
    }

    @Test
    void shouldValidateEmptyContentCorrectly() {
        TestFdRequest fdRequest = new TestFdRequest();
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 204, HEADERS_JSON);
        FdResponse response = responseCreator.takeExpectationFrom((FdRequest)fdRequest).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertTrue((boolean)response.isValidPayload());
    }

    @Test
    void shouldValidateOperationOutcomeCorrectly() {
        String testOperationOutcome = this.encodeTestRessource((Resource)FhirTestResourceUtil.createOperationOutcome(), EncodingType.JSON);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 204, HEADERS_JSON, testOperationOutcome);
        FdResponse response = responseCreator.expecting(AuditEvent.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertTrue((boolean)response.isValidPayload());
    }

    @Test
    void shouldFailOnInvalidOperationOutcomeCorrectly() {
        String testOperationOutcome = this.encodeTestRessource((Resource)FhirTestResourceUtil.createOperationOutcome(), EncodingType.JSON).replace("issue", "issues");
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 204, HEADERS_JSON, testOperationOutcome);
        FdResponse response = responseCreator.expecting(AuditEvent.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertFalse((boolean)response.isValidPayload());
    }

    @Test
    void shouldCheckHeadersCorrectly() {
        String testOperationOutcome = this.encodeTestRessource((Resource)FhirTestResourceUtil.createOperationOutcome(), EncodingType.JSON);
        LinkedList<HttpHeader> headers = new LinkedList<HttpHeader>();
        headers.add(StandardHttpHeaderKey.CONTENT_LENGTH.createHeader(String.valueOf(testOperationOutcome.length())));
        headers.addAll(HEADERS_JSON);
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 404, headers, testOperationOutcome);
        FdResponse response = responseCreator.expecting(AuditEvent.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertTrue((boolean)response.isJson());
        Assertions.assertFalse((boolean)response.isXML());
        Assertions.assertTrue((response.getContentLength() > 0L ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)response.isEmptyBody());
        Assertions.assertTrue((boolean)response.toString().contains(OperationOutcome.class.getSimpleName()));
        Assertions.assertTrue((boolean)response.toString().contains("404"));
    }

    @Test
    void shouldCheckHeadersCorrectly02() {
        String testOperationOutcome = this.encodeTestRessource((Resource)FhirTestResourceUtil.createOperationOutcome(), EncodingType.XML);
        LinkedList<HttpHeader> headers = new LinkedList<HttpHeader>();
        headers.add(StandardHttpHeaderKey.CONTENT_TYPE.createHeader(MediaType.FHIR_XML.asString()));
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 404, headers, testOperationOutcome);
        FdResponse response = responseCreator.expecting(AuditEvent.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertFalse((boolean)response.isJson());
        Assertions.assertTrue((boolean)response.isXML());
        Assertions.assertEquals((long)0L, (long)response.getContentLength());
        Assertions.assertTrue((boolean)response.isEmptyBody());
        Assertions.assertTrue((boolean)response.toString().contains(OperationOutcome.class.getSimpleName()));
        Assertions.assertTrue((boolean)response.toString().contains("404"));
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "\t", "\n", "\n\r", "\r", "\n\n\t"})
    @NullSource
    void shouldThrowOnMissingAnyResponseBody(String emptyBody) {
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 500, HEADERS_JSON, emptyBody);
        FdResponse response = responseCreator.expecting(AuditEvent.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertEquals(EmptyResource.class, (Object)response.getResourceType());
        Assertions.assertTrue((boolean)response.isEmptyBody());
        Assertions.assertTrue((boolean)response.isJson());
        Assertions.assertFalse((boolean)response.isXML());
        Assertions.assertTrue((boolean)response.toString().contains(EmptyResource.class.getSimpleName()));
        Assertions.assertThrows(UnexpectedResponseResourceError.class, () -> ((FdResponse)response).getExpectedResource());
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "\t", "\n"})
    @NullSource
    void shouldCreateEmptyResponsesOnEmptyPayloadBody(String payload) {
        HttpBResponse httpResponse = new HttpBResponse(PROTOCOL, 500, HEADERS_JSON, payload);
        FdResponse response = responseCreator.expecting(AuditEvent.class).usedAccessToken(testToken).received(httpResponse).withoutDuration();
        Assertions.assertEquals(EmptyResource.class, (Object)response.getResourceType());
        Assertions.assertTrue((boolean)response.isEmptyBody());
        Assertions.assertTrue((boolean)response.toString().contains(EmptyResource.class.getSimpleName()));
        Assertions.assertThrows(UnexpectedResponseResourceError.class, () -> ((FdResponse)response).getExpectedResource());
    }

    static {
        HEADERS_JSON = List.of(new HttpHeader("content-type", MediaType.FHIR_JSON.asString()));
    }

    private static class TestFdRequest
    extends FdBaseRequest<EmptyResource, EmptyResource> {
        protected TestFdRequest() {
            super(EmptyResource.class, HttpRequestMethod.POST, "/test");
        }

        public EmptyResource getRequestBody() {
            return new EmptyResource();
        }
    }
}

