/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import ca.uhn.fhir.context.FhirContext;
import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.fhir.codec.exceptions.FhirCodecException;
import de.gematik.bbriccs.fhir.validation.DummyValidator;
import de.gematik.bbriccs.fhir.validation.ValidatorFhir;
import de.gematik.bbriccs.rest.HttpBClient;
import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.fd.FdBaseRequest;
import de.gematik.bbriccs.rest.fd.FdClient;
import de.gematik.bbriccs.rest.fd.FdRequest;
import de.gematik.bbriccs.rest.fd.FdResponse;
import de.gematik.bbriccs.rest.fd.MediaType;
import de.gematik.bbriccs.rest.fd.exceptions.UnsupportedMediaTypeException;
import de.gematik.bbriccs.rest.fd.plugins.FhirCodecObserver;
import de.gematik.bbriccs.rest.fd.plugins.RequestHeaderProvider;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.JwtHeaderKey;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class FdClientTest {
    FdClientTest() {
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"EMPTY", "UNKNOWN"})
    void shouldFailOnBuildingWithUnsupportedMimeTypes(MediaType mt) {
        FdClient.FdClientBuilder fdcb = FdClient.via(null);
        Assertions.assertThrows(UnsupportedMediaTypeException.class, () -> fdcb.usingFhirMimeType(mt));
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"FHIR_XML", "FHIR_JSON"})
    void shouldDecodeWithAcceptMime(MediaType mediaType) {
        String content = ResourceLoader.readFileFromResource((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        TestHttpClient httpClient = new TestHttpClient();
        FdClient fdClient = FdClient.via((HttpBClient)httpClient).usingDefaultFhir(false).acceptingUtf8Charset().usingFhirMimeType(mediaType).build();
        if (mediaType.isEquivalentTo(MediaType.FHIR_XML)) {
            Assertions.assertDoesNotThrow(() -> (Bundle)fdClient.decode(Bundle.class, content));
        } else {
            Assertions.assertThrows(FhirCodecException.class, () -> fdClient.decode(Bundle.class, content));
        }
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"APPLICATION_XML", "APPLICATION_JSON", "FHIR_XML", "FHIR_JSON"})
    void shouldValidateAnyContentType(MediaType mediaType) {
        String content = ResourceLoader.readFileFromResource((String)"examples/fhir/valid/erp/kbv/1.1.0/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        TestHttpClient httpClient = new TestHttpClient();
        FdClient fdClient = FdClient.via((HttpBClient)httpClient).usingDefaultFhir((ValidatorFhir)new DummyValidator(FhirContext.forR4())).acceptingUtf8Charset().usingMimeType(mediaType).build();
        Assertions.assertTrue((boolean)fdClient.isValid(content));
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"FHIR_XML", "FHIR_JSON"})
    void shouldSendRequestViaTestHttpClient(MediaType mediaType) {
        TestHttpClient httpClient = new TestHttpClient();
        FdClient fdClient = FdClient.via((HttpBClient)httpClient).usingDefaultFhir(false).acceptingUtf8Charset().usingFhirMimeType(mediaType).withHeaderProvider((RequestHeaderProvider)new TestHeaderProvider()).build();
        FdResponse response = (FdResponse)Assertions.assertDoesNotThrow(() -> fdClient.request((FdRequest)new TestFdRequest()));
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertEquals((int)1, (int)httpClient.requests.size());
        Assertions.assertEquals((Object)"Bearer ABC", (Object)httpClient.requests.get(0).headerValue(JwtHeaderKey.AUTHORIZATION.getKey()));
        Assertions.assertEquals((Object)"ABC", (Object)response.getUsedJwt());
    }

    @ParameterizedTest
    @EnumSource(value=MediaType.class, names={"FHIR_XML", "FHIR_JSON"})
    void shouldServeObservers(MediaType mediaType) {
        TestFhirCodecObserver observer = new TestFhirCodecObserver();
        TestHttpClient httpClient = new TestHttpClient();
        FdClient fdClient = FdClient.via((HttpBClient)httpClient).usingDefaultFhir(false).acceptingUtf8Charset().usingFhirMimeType(mediaType).registerForFhir((FhirCodecObserver)observer).withHeaderProvider((RequestHeaderProvider)new TestHeaderProvider()).build();
        FdResponse response = (FdResponse)Assertions.assertDoesNotThrow(() -> fdClient.request((FdRequest)new TestFdRequest()));
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertEquals((int)1, (int)httpClient.requests.size());
        Assertions.assertEquals((int)1, (int)observer.decodeCounter);
        Assertions.assertEquals((int)1, (int)observer.encodeCounter);
    }

    private static class TestHttpClient
    implements HttpBClient {
        private final List<HttpBRequest> requests = new LinkedList<HttpBRequest>();

        private TestHttpClient() {
        }

        public HttpBResponse send(HttpBRequest bRequest) {
            this.requests.add(bRequest);
            return new HttpBResponse(200, List.of());
        }
    }

    private static class TestHeaderProvider
    implements RequestHeaderProvider {
        private TestHeaderProvider() {
        }

        public HttpHeader forRequest(FdRequest<? extends Resource, ? extends Resource> request) {
            return JwtHeaderKey.AUTHORIZATION.createHeader("ABC");
        }
    }

    private static class TestFhirCodecObserver
    implements FhirCodecObserver {
        private int decodeCounter = 0;
        private int encodeCounter = 0;

        private TestFhirCodecObserver() {
        }

        public <E extends Resource, R extends Resource> void onDecode(Class<E> expectedType, String content, R resource) {
            ++this.decodeCounter;
        }

        public <R extends Resource> void onEncode(R resource, String content) {
            ++this.encodeCounter;
        }
    }

    private static class TestFdRequest
    extends FdBaseRequest<EmptyResource, EmptyResource> {
        protected TestFdRequest() {
            super(EmptyResource.class, HttpRequestMethod.GET, "/Task");
        }

        public EmptyResource getRequestBody() {
            return new EmptyResource();
        }
    }
}

