/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.fd.FdBaseRequest;
import de.gematik.bbriccs.rest.fd.query.QueryParameter;
import de.gematik.bbriccs.rest.fd.query.SearchPrefix;
import de.gematik.bbriccs.rest.fd.query.SearchQueryParameter;
import java.util.List;
import org.hl7.fhir.r4.model.Task;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class FdBaseRequestTest {
    FdBaseRequestTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"task", "/task"})
    void shouldCalculatePath(String resource) {
        TestFdRequest01 tr = new TestFdRequest01(HttpRequestMethod.POST, resource);
        Assertions.assertEquals((Object)HttpRequestMethod.POST, (Object)tr.getMethod());
        Assertions.assertEquals((Object)"/task", (Object)tr.getResourcePath());
        Assertions.assertEquals((Object)tr.getResourcePath(), (Object)tr.getRequestLocator());
        Assertions.assertTrue((boolean)tr.getHeaderParameters().isEmpty());
        Assertions.assertTrue((boolean)tr.getHeaders().isEmpty());
    }

    @Test
    void shouldCalculateLocatorWithQuery() {
        List<SearchQueryParameter> qp = List.of(new SearchQueryParameter("authoredOn", SearchPrefix.GE, "2023"), new SearchQueryParameter("updated", SearchPrefix.EQ, "2024"));
        TestFdRequest01 tr = new TestFdRequest01(qp);
        Assertions.assertEquals((Object)"/task", (Object)tr.getResourcePath());
        Assertions.assertEquals((Object)"/task?authoredOn=ge2023&updated=eq2024", (Object)tr.getRequestLocator());
    }

    @Test
    void shouldCalculateLocatorWithQueryAndId() {
        List<SearchQueryParameter> qp = List.of(new SearchQueryParameter("authoredOn", SearchPrefix.GE, "2023"), new SearchQueryParameter("updated", SearchPrefix.EQ, "2024"));
        TestFdRequest01 tr = new TestFdRequest01("890567", qp);
        Assertions.assertEquals((Object)"/task/890567", (Object)tr.getResourcePath());
        Assertions.assertEquals((Object)"/task/890567?authoredOn=ge2023&updated=eq2024", (Object)tr.getRequestLocator());
    }

    private static class TestFdRequest01
    extends FdBaseRequest<EmptyResource, Task> {
        protected TestFdRequest01(HttpRequestMethod httpMethod, String fhirResource) {
            super(Task.class, httpMethod, fhirResource);
        }

        protected TestFdRequest01(List<QueryParameter> qp) {
            this(HttpRequestMethod.POST, "/task");
            this.queryParameters.addAll(qp);
        }

        protected TestFdRequest01(String resourceId, List<QueryParameter> qp) {
            super(Task.class, HttpRequestMethod.POST, "/task", resourceId);
            this.queryParameters.addAll(qp);
        }

        public EmptyResource getRequestBody() {
            return new EmptyResource();
        }
    }
}

