/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.fd;

import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.fd.FdRequest;
import de.gematik.bbriccs.rest.fd.query.QueryParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Resource;

public abstract class FdBaseRequest<T extends Resource, R extends Resource>
implements FdRequest<T, R> {
    private final Class<R> expectedResponse;
    private final HttpRequestMethod httpRequestMethod;
    private final String fhirResource;
    private final String resourceId;
    protected final List<QueryParameter> queryParameters;
    protected final Map<String, String> headerParameters;

    protected FdBaseRequest(Class<R> expect, HttpRequestMethod method, String fhirResource) {
        this(expect, method, fhirResource, null);
    }

    protected FdBaseRequest(Class<R> expect, HttpRequestMethod method, String fhirResource, String resourceId) {
        this.expectedResponse = expect;
        this.httpRequestMethod = method;
        this.fhirResource = fhirResource;
        this.resourceId = resourceId;
        this.queryParameters = new ArrayList<QueryParameter>();
        this.headerParameters = new HashMap<String, String>();
    }

    @Override
    public final String getFhirResource() {
        return this.fhirResource.startsWith("/") ? this.fhirResource : "/" + this.fhirResource;
    }

    protected final String getResourcePath() {
        Object ret = this.getFhirResource();
        if (this.resourceId != null) {
            ret = (String)ret + "/" + this.resourceId;
        }
        return ret;
    }

    @Override
    public String getRequestLocator() {
        return this.getResourcePath() + this.getQueryPart();
    }

    @Override
    public final HttpRequestMethod getMethod() {
        return this.httpRequestMethod;
    }

    @Override
    public final Map<String, String> getHeaderParameters() {
        return this.headerParameters;
    }

    @Override
    public final Class<R> expectedResponseType() {
        return this.expectedResponse;
    }

    protected String getQueryPart() {
        if (this.queryParameters.isEmpty()) {
            return "";
        }
        return "?" + this.queryParameters.stream().map(QueryParameter::encode).collect(Collectors.joining("&"));
    }
}

