/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.signature;

import de.gematik.bbriccs.crypto.signature.Signature;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jcajce.provider.util.DigestFactory;

public class RsaPssSigner
implements Signature<PrivateKey, PublicKey> {
    private final byte trailer;
    private final Digest contentDigest;
    private final RSABlindedEngine cipher = new RSABlindedEngine();
    private final int hLen;
    private final int sLen;
    private int emBits;
    private byte[] block;
    private SecureRandom random;
    private final int mgfhLen;

    private RsaPssSigner(PSSParameterSpec spec) {
        this.contentDigest = DigestFactory.getDigest((String)spec.getDigestAlgorithm());
        this.trailer = (byte)-68;
        this.hLen = this.contentDigest.getDigestSize();
        this.mgfhLen = this.contentDigest.getDigestSize();
        this.sLen = spec.getSaltLength();
    }

    @Override
    public byte[] sign(PrivateKey key, byte[] data) {
        this.init((CipherParameters)this.generatePrivateKeyParameter((RSAPrivateKey)key));
        byte[] salt = new byte[this.sLen];
        byte[] mDash = new byte[8 + this.sLen + this.hLen];
        System.arraycopy(data, 0, mDash, 8, data.length);
        this.random.nextBytes(salt);
        System.arraycopy(salt, 0, mDash, mDash.length - this.sLen, this.sLen);
        byte[] h = new byte[this.hLen];
        this.contentDigest.update(mDash, 0, mDash.length);
        this.contentDigest.doFinal(h, 0);
        this.block[this.block.length - this.sLen - 1 - this.hLen - 1] = 1;
        System.arraycopy(salt, 0, this.block, this.block.length - this.sLen - this.hLen - 1, this.sLen);
        byte[] dbMask = this.maskGeneratorFunction1(h, 0, h.length, this.block.length - this.hLen - 1);
        for (int i = 0; i != dbMask.length; ++i) {
            int n = i;
            this.block[n] = (byte)(this.block[n] ^ dbMask[i]);
        }
        this.block[0] = (byte)(this.block[0] & 255 >> this.block.length * 8 - this.emBits);
        System.arraycopy(h, 0, this.block, this.block.length - this.hLen - 1, this.hLen);
        this.block[this.block.length - 1] = this.trailer;
        byte[] ret = this.cipher.processBlock(this.block, 0, this.block.length);
        Arrays.fill(this.block, (byte)0);
        return ret;
    }

    private byte[] maskGeneratorFunction1(byte[] z, int zOff, int zLen, int length) {
        int counter;
        byte[] mask = new byte[length];
        byte[] hashBuf = new byte[this.mgfhLen];
        byte[] c = new byte[4];
        this.contentDigest.reset();
        for (counter = 0; counter < length / this.mgfhLen; ++counter) {
            this.int2Octet(counter, c);
            this.contentDigest.update(z, zOff, zLen);
            this.contentDigest.update(c, 0, c.length);
            this.contentDigest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * this.mgfhLen, this.mgfhLen);
        }
        if (counter * this.mgfhLen < length) {
            this.int2Octet(counter, c);
            this.contentDigest.update(z, zOff, zLen);
            this.contentDigest.update(c, 0, c.length);
            this.contentDigest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * this.mgfhLen, mask.length - counter * this.mgfhLen);
        }
        return mask;
    }

    private void init(CipherParameters param) {
        this.random = new SecureRandom();
        RSAKeyParameters kParam = (RSAKeyParameters)param;
        this.cipher.init(true, param);
        this.emBits = kParam.getModulus().bitLength() - 1;
        this.block = new byte[(this.emBits + 7) / 8];
        this.reset();
    }

    private void int2Octet(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)i;
    }

    private void reset() {
        this.contentDigest.reset();
    }

    private RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey key) {
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey crtKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(crtKey.getModulus(), crtKey.getPublicExponent(), crtKey.getPrivateExponent(), crtKey.getPrimeP(), crtKey.getPrimeQ(), crtKey.getPrimeExponentP(), crtKey.getPrimeExponentQ(), crtKey.getCrtCoefficient());
        }
        return new RSAKeyParameters(true, key.getModulus(), key.getPrivateExponent());
    }

    public static RsaPssSigner sha256withMgf1() {
        PSSParameterSpec spec = new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1);
        return new RsaPssSigner(spec);
    }

    @Override
    public byte[] verify(PublicKey key, byte[] data) {
        throw new UnsupportedOperationException();
    }
}

