/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.encryption.cms;

import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.crypto.certificate.X509CertificateWrapper;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.List;
import java.util.Optional;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSAuthEnvelopedData;
import org.bouncycastle.cms.CMSAuthEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.AsymmetricKeyWrapper;
import org.bouncycastle.operator.OutputAEADEncryptor;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.jcajce.JceAsymmetricKeyWrapper;

public class CmsAuthEnvelopedData {
    public byte[] encrypt(List<X509Certificate> recipientCertificates, byte[] plaintext) {
        List<X509CertificateWrapper> certs = recipientCertificates.stream().map(X509CertificateWrapper::new).toList();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(plaintext);
        CMSAuthEnvelopedDataGenerator edGen = new CMSAuthEnvelopedDataGenerator();
        ASN1EncodableVector info = this.buildRecipientInfo(certs);
        edGen.setUnauthenticatedAttributeGenerator((CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(new AttributeTable(new Attribute(new ASN1ObjectIdentifier("1.2.276.0.76.4.173"), (ASN1Set)new DERSet(info)))));
        JcaX509CertificateConverter jcaConverter = new JcaX509CertificateConverter().setProvider(BC.getSecurityProvider());
        for (X509CertificateWrapper cert : certs) {
            X509Certificate jcaCert = jcaConverter.getCertificate(cert.toCertificateHolder());
            edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(jcaCert, (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper((AlgorithmParameterSpec)new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT), jcaCert.getPublicKey())).setProvider(BC.getSecurityProvider()));
        }
        OutputEncryptor contentEncryptor = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_GCM).setProvider(BC.getSecurityProvider()).build();
        CMSAuthEnvelopedData ed = edGen.generate((CMSTypedData)msg, (OutputAEADEncryptor)contentEncryptor);
        return ed.toASN1Structure().getEncoded();
    }

    private ASN1EncodableVector buildRecipientInfo(List<X509CertificateWrapper> recipientCertificates) {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        recipientCertificates.forEach(recipientCert -> {
            ASN1EncodableVector t = new ASN1EncodableVector();
            t.add((ASN1Encodable)new DERIA5String(recipientCert.getTelematikId().orElseThrow(), true));
            t.add((ASN1Encodable)new RecipientIdentifier(new IssuerAndSerialNumber(recipientCert.toCertificateHolder().toASN1Structure())));
            vector.add((ASN1Encodable)new DERSequence(t));
        });
        return vector;
    }

    public byte[] decrypt(PrivateKey key, byte[] cmsEnvelopedDataAsByte) {
        CMSAuthEnvelopedData cmsEnvelopedData = new CMSAuthEnvelopedData(cmsEnvelopedDataAsByte);
        RecipientInformationStore recipients = cmsEnvelopedData.getRecipientInfos();
        Optional recipientInformation = recipients.getRecipients().stream().findFirst();
        return ((RecipientInformation)recipientInformation.orElseThrow()).getContent((Recipient)new JceKeyTransEnvelopedRecipient(key).setProvider(BC.getSecurityProvider()));
    }

    @Generated
    public CmsAuthEnvelopedData() {
    }
}

