/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.certificate;

import de.gematik.bbriccs.crypto.exceptions.UnsupportedOidException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;

public interface Oid {
    public String getValue();

    public String getDisplay();

    public static <O extends Enum<O>> Optional<O> fromString(Class<O> oidClass, String oid) {
        return Arrays.stream((Enum[])oidClass.getEnumConstants()).filter(it -> ((Oid)((Object)it)).getValue().equals(oid)).findFirst();
    }

    public static <O extends Enum<O>> O fromStringOrThrow(Class<O> oidClass, String oid) {
        return (O)((Enum)Oid.fromString(oidClass, oid).orElseThrow(() -> new UnsupportedOidException(MessageFormat.format("Unknown OID: {0}", oid))));
    }
}

