/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.certificate;

import de.gematik.bbriccs.crypto.certificate.Oid;
import java.text.MessageFormat;
import java.util.Optional;
import lombok.Generated;

public enum CertificateTypeOid implements Oid
{
    OID_EGK_AUT("CH.AUT", "1.2.276.0.76.4.70"),
    OID_EGK_AUT_ALT("CH.AUT", "1.2.276.0.76.4.212"),
    OID_HBA_QES("HP.QES", "1.2.276.0.76.4.72"),
    OID_HBA_ENC("HP.ENC", "1.2.276.0.76.4.74"),
    OID_HBA_AUT("HP.AUT", "1.2.276.0.76.4.75"),
    OID_SMC_B_ENC("HCI.ENC", "1.2.276.0.76.4.76"),
    OID_SMC_B_AUT("HCI.AUT", "1.2.276.0.76.4.77"),
    OID_SMC_B_OSIG("HCI.OSIG", "1.2.276.0.76.4.78");

    private final String type;
    private final String value;

    public static Optional<CertificateTypeOid> getByOid(String oid) {
        return Oid.fromString(CertificateTypeOid.class, oid);
    }

    public String asCertType() {
        return MessageFormat.format("C.{0}", this.type);
    }

    @Override
    public String getDisplay() {
        return this.asCertType();
    }

    public String toString() {
        return MessageFormat.format("Name: {0} Type: {1} Oid: {2}", this.name(), this.type, this.value);
    }

    @Generated
    private CertificateTypeOid(String type, String value) {
        this.type = type;
        this.value = value;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getValue() {
        return this.value;
    }
}

