/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto;

import de.gematik.bbriccs.crypto.CryptographySpecification;
import de.gematik.bbriccs.crypto.exceptions.InvalidCryptographySpecificationException;
import de.gematik.bbriccs.crypto.exceptions.UnsupportedCryptographySystemException;
import java.text.MessageFormat;
import java.util.Arrays;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public enum CryptoSystem {
    RSA_2048("RSA", CryptographySpecification.RSA, PKCSObjectIdentifiers.sha256WithRSAEncryption, 2048),
    RSA_PSS_2048("RSASSA-PSS", CryptographySpecification.RSA, PKCSObjectIdentifiers.id_RSASSA_PSS, 2048),
    ECC_256("ECC", CryptographySpecification.ECC, X9ObjectIdentifiers.ecdsa_with_SHA256, 256);

    public static final CryptoSystem DEFAULT_CRYPTO_SYSTEM;
    private final String name;
    private final int keyLength;
    private final ASN1ObjectIdentifier oid;
    private final CryptographySpecification specification;

    private CryptoSystem(String name, CryptographySpecification standard, ASN1ObjectIdentifier oid, int keyLength) {
        this.name = name;
        this.oid = oid;
        this.keyLength = keyLength;
        this.specification = standard;
    }

    public static CryptoSystem fromString(String value) {
        return switch (value.toUpperCase().replace("-", "_")) {
            case "RSA_2048", "R2048", "RSA" -> RSA_2048;
            case "RSASSA_PSS" -> RSA_PSS_2048;
            case "E256", "ECC_256", "ECC", "RSA_ECC" -> ECC_256;
            default -> throw new UnsupportedCryptographySystemException(MessageFormat.format("Cryptography {0} is not supported", value));
        };
    }

    public static CryptoSystem fromOid(ASN1ObjectIdentifier oid) {
        return Arrays.stream(CryptoSystem.values()).filter(it -> it.oid.equals((ASN1Primitive)oid)).findFirst().orElseThrow(() -> new UnsupportedCryptographySystemException(MessageFormat.format("Cryptography Oid {0} is not supported", oid)));
    }

    public static CryptoSystem fromSpecificationUrn(String urn) {
        CryptographySpecification standard = CryptographySpecification.fromUrn(urn);
        return Arrays.stream(CryptoSystem.values()).filter(it -> it.getSpecification().equals((Object)standard)).findFirst().orElseThrow(() -> new InvalidCryptographySpecificationException(urn));
    }

    public String toString() {
        return this.name + " " + this.keyLength;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getKeyLength() {
        return this.keyLength;
    }

    @Generated
    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    @Generated
    public CryptographySpecification getSpecification() {
        return this.specification;
    }

    static {
        DEFAULT_CRYPTO_SYSTEM = ECC_256;
    }
}

