/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.signature;

import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.crypto.signature.RsaPssSigner;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RsaPssSignerTest {
    private PrivateKey privateKey;
    private PublicKey publicKey;

    RsaPssSignerTest() {
    }

    @BeforeEach
    void setUp() {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", BC.getSecurityProvider());
        kpg.initialize(2048);
        KeyPair kp = kpg.generateKeyPair();
        this.privateKey = kp.getPrivate();
        this.publicKey = kp.getPublic();
    }

    @Test
    void shouldGenerateSignature() {
        RsaPssSigner signer = RsaPssSigner.sha256withMgf1();
        Assertions.assertDoesNotThrow(() -> signer.sign(this.privateKey, "Test".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    void validSignatureLength() {
        RsaPssSigner signer = RsaPssSigner.sha256withMgf1();
        byte[] sign = signer.sign(this.privateKey, "Test".getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((int)256, (int)sign.length);
    }

    @Test
    void signatureValidationNotSupported() {
        RsaPssSigner signer = RsaPssSigner.sha256withMgf1();
        byte[] data = "Test".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> signer.verify(this.publicKey, data));
    }
}

