/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.signature;

import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.crypto.signature.EcdsaSigner;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class EcdsaSignerTest {
    private PrivateKey privateKey;
    private PublicKey publicKey;

    EcdsaSignerTest() {
    }

    @BeforeEach
    void setUp() {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", BC.getSecurityProvider());
        ECGenParameterSpec spec = new ECGenParameterSpec("secp256r1");
        kpg.initialize(spec);
        KeyPair kp = kpg.generateKeyPair();
        this.privateKey = kp.getPrivate();
        this.publicKey = kp.getPublic();
    }

    @Test
    void shouldGenerateSignature() {
        EcdsaSigner signer = new EcdsaSigner();
        Assertions.assertDoesNotThrow(() -> signer.sign(this.privateKey, "Test".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    void shouldThrowOnVerify() {
        EcdsaSigner signer = new EcdsaSigner();
        byte[] data = "Test".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> signer.verify(this.publicKey, data));
    }

    @Test
    void shouldThrowOnSigningWithInvalidKey() {
        EcdsaSigner signer = new EcdsaSigner();
        byte[] data = "Test".getBytes(StandardCharsets.UTF_8);
        PrivateKey privateKey = (PrivateKey)Mockito.mock(PrivateKey.class);
        Assertions.assertThrows(InvalidKeyException.class, () -> signer.sign(privateKey, data));
    }
}

