/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.encryption.cms;

import de.gematik.bbriccs.crypto.encryption.cms.CmsAuthEnvelopedData;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CmsAuthEnvelopedDataTest {
    private PrivateKey privateKey;
    private X509Certificate x509Certificate;

    CmsAuthEnvelopedDataTest() {
    }

    @BeforeEach
    void setUp() {
        InputStream is = ClassLoader.getSystemResourceAsStream("80276883110000116873-C_HCI_ENC_R2048.p12");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(is, "00".toCharArray());
        String alias = ks.aliases().nextElement();
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection("00".toCharArray()));
        this.x509Certificate = (X509Certificate)privateKeyEntry.getCertificate();
        this.privateKey = privateKeyEntry.getPrivateKey();
    }

    @Test
    void test() {
        CmsAuthEnvelopedData cmsAuthEnvelopedData = new CmsAuthEnvelopedData();
        byte[] encrypt = cmsAuthEnvelopedData.encrypt(List.of(this.x509Certificate), "Test".getBytes(StandardCharsets.UTF_8));
        byte[] decrypt = cmsAuthEnvelopedData.decrypt(this.privateKey, encrypt);
        Assertions.assertEquals((Object)"Test", (Object)new String(decrypt, StandardCharsets.UTF_8));
    }
}

