/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.encryption;

import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.crypto.encryption.AesGcm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.AEADBadTagException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class AesGcmTest {
    private static SecretKey symKey;

    AesGcmTest() {
    }

    @BeforeAll
    static void setup() {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES", BC.getSecurityProvider());
        keyGen.init(128);
        symKey = keyGen.generateKey();
    }

    @Test
    void encryptAndDecrypt() {
        AesGcm aesGcm = new AesGcm(12, 16);
        byte[] encryptedContent = aesGcm.encrypt(symKey, "Test".getBytes(StandardCharsets.UTF_8));
        byte[] decrypted = aesGcm.decrypt((Key)symKey, encryptedContent);
        Assertions.assertEquals((Object)"Test", (Object)new String(decrypted, StandardCharsets.UTF_8));
    }

    @Test
    void shouldThrowOnDecrypt() {
        AesGcm aesGcm = new AesGcm(12, 16);
        byte[] encryptedContent = aesGcm.encrypt(symKey, "Test".getBytes(StandardCharsets.UTF_8));
        String e = new String(encryptedContent) + "00";
        Assertions.assertThrows(AEADBadTagException.class, () -> aesGcm.decrypt((Key)symKey, e.getBytes()));
    }
}

