/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.signature;

import de.gematik.bbriccs.crypto.signature.Signature;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;

public class EcdsaSigner
implements Signature<PrivateKey, PublicKey> {
    @Override
    public byte[] sign(PrivateKey key, byte[] data) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        AsymmetricKeyParameter param = ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        signer.init(true, (CipherParameters)param);
        BigInteger[] signature = signer.generateSignature(data);
        StandardDSAEncoding encoder = new StandardDSAEncoding();
        ECDomainParameters parameters = ((ECPrivateKeyParameters)param).getParameters();
        return encoder.encode(parameters.getN(), signature[0], signature[1]);
    }

    @Override
    public byte[] verify(PublicKey key, byte[] data) {
        throw new UnsupportedOperationException();
    }
}

