/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto;

import de.gematik.bbriccs.crypto.exceptions.InvalidCryptographySpecificationException;
import java.util.Arrays;
import lombok.Generated;

public enum CryptographySpecification {
    RSA("urn:ietf:rfc:3447"),
    ECC("urn:bsi:tr:03111:ecdsa");

    private final String urn;

    public static CryptographySpecification fromUrn(String urn) {
        return Arrays.stream(CryptographySpecification.values()).filter(it -> it.getUrn().equals(urn)).findFirst().orElseThrow(() -> new InvalidCryptographySpecificationException(urn));
    }

    @Generated
    public String getUrn() {
        return this.urn;
    }

    @Generated
    private CryptographySpecification(String urn) {
        this.urn = urn;
    }
}

