/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto;

import java.security.Provider;
import java.security.Security;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class BC {
    private static final Provider SECURITY_PROVIDER = new BouncyCastleProvider();
    private static boolean initialized;

    private BC() {
    }

    public static void init() {
        if (!initialized) {
            Security.removeProvider("BC");
            Security.insertProviderAt(SECURITY_PROVIDER, 1);
            Security.setProperty("org.bouncycastle.rsa.allow_unsafe_mod", "true");
            initialized = true;
        }
    }

    public static Provider getSecurityProvider() {
        return SECURITY_PROVIDER;
    }

    public static SecretKey generateAESDecryptionKey(int keySize) {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", BC.getSecurityProvider());
        keyGenerator.init(keySize);
        return keyGenerator.generateKey();
    }

    static {
        BC.init();
    }
}

