/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.encryption;

import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.crypto.encryption.Ciphers;
import de.gematik.bbriccs.crypto.encryption.EncryptionMethod;
import de.gematik.bbriccs.crypto.exceptions.EncryptionException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;

public class Ecies
implements EncryptionMethod<ECPublicKey, PrivateKey> {
    private final byte version;
    private final byte[] info;
    private final int ivSize;
    private final int aesSize;
    private final String curve;

    private SecretKeySpec genAesKey(ECPublicKey otherECPublicKey, PrivateKey privateKey) {
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH", BC.getSecurityProvider());
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(otherECPublicKey, true);
        byte[] secret = keyAgreement.generateSecret();
        byte[] aesKey = new byte[this.aesSize];
        HKDFBytesGenerator hkdfBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdfBytesGenerator.init((DerivationParameters)new HKDFParameters(secret, null, this.info));
        hkdfBytesGenerator.generateBytes(aesKey, 0, aesKey.length);
        return new SecretKeySpec(aesKey, "AES");
    }

    @Override
    public byte[] encrypt(ECPublicKey otherECPublicKey, byte[] plain) {
        byte[] ivBytes = new byte[this.ivSize];
        new SecureRandom().nextBytes(ivBytes);
        IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", BC.getSecurityProvider());
        keyPairGenerator.initialize(new ECGenParameterSpec(this.curve));
        KeyPair eKp = keyPairGenerator.generateKeyPair();
        SecretKeySpec aesKey = this.genAesKey(otherECPublicKey, eKp.getPrivate());
        byte[] cipherText = Ciphers.AES_GCM.initEncryptMode(aesKey, ivSpec).doFinal(plain);
        byte[] x = ((ECPublicKey)eKp.getPublic()).getW().getAffineX().toByteArray();
        byte[] y = ((ECPublicKey)eKp.getPublic()).getW().getAffineY().toByteArray();
        byte[] ret = new byte[65 + this.ivSize + cipherText.length];
        System.arraycopy(y, 0, ret, 65 - y.length, y.length);
        System.arraycopy(x, 0, ret, 33 - x.length, x.length);
        ret[0] = this.version;
        System.arraycopy(ivBytes, 0, ret, 65, ivBytes.length);
        System.arraycopy(cipherText, 0, ret, 65 + this.ivSize, cipherText.length);
        return ret;
    }

    @Override
    public byte[] decrypt(PrivateKey privateKey, byte[] encryptedData) {
        if (encryptedData[0] != this.version) {
            throw new EncryptionException("Invalid version byte");
        }
        if (encryptedData.length <= 65 + this.ivSize) {
            throw new EncryptionException("Ciphertext too small!");
        }
        BigInteger x = new BigInteger(1, this.copyOfRange(encryptedData, 1, 33));
        BigInteger y = new BigInteger(1, this.copyOfRange(encryptedData, 33, 65));
        ECNamedCurveParameterSpec curveSpec = ECNamedCurveTable.getParameterSpec((String)this.curve);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(curveSpec.getCurve().createPoint(x, y), (ECParameterSpec)curveSpec);
        PublicKey otherPublicKey = KeyFactory.getInstance("EC").generatePublic((KeySpec)ecPublicKeySpec);
        IvParameterSpec ivSpec = new IvParameterSpec(encryptedData, 65, this.ivSize);
        SecretKeySpec aesKey = this.genAesKey((ECPublicKey)otherPublicKey, privateKey);
        return Ciphers.AES_GCM.initDecryptMode(aesKey, ivSpec).doFinal(encryptedData, 65 + this.ivSize, encryptedData.length - (65 + this.ivSize));
    }

    private byte[] copyOfRange(byte[] data, int fromIndex, int toIndex) {
        byte[] ret = new byte[toIndex - fromIndex];
        System.arraycopy(data, fromIndex, ret, 0, ret.length);
        return ret;
    }

    @Generated
    public Ecies(byte version, byte[] info, int ivSize, int aesSize, String curve) {
        this.version = version;
        this.info = info;
        this.ivSize = ivSize;
        this.aesSize = aesSize;
        this.curve = curve;
    }

    @Generated
    public String getCurve() {
        return this.curve;
    }
}

