/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.encryption;

import de.gematik.bbriccs.crypto.encryption.Ciphers;
import de.gematik.bbriccs.crypto.encryption.EncryptionMethod;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import lombok.Generated;

public class AesGcm
implements EncryptionMethod<SecretKey, Key> {
    private final int ivSize;
    private final int tagSize;

    @Override
    public byte[] decrypt(Key aesKey, byte[] encryptedData) {
        return Ciphers.AES_GCM.initDecryptMode(aesKey, new GCMParameterSpec(this.tagSize * 8, encryptedData, 0, this.ivSize)).doFinal(encryptedData, this.ivSize, encryptedData.length - this.ivSize);
    }

    @Override
    public byte[] encrypt(SecretKey aesKey, byte[] plain) {
        byte[] ivBytes = new byte[this.ivSize];
        new SecureRandom().nextBytes(ivBytes);
        byte[] cipherBA = Ciphers.AES_GCM.initEncryptMode(aesKey, new GCMParameterSpec(this.tagSize * 8, ivBytes)).doFinal(plain);
        byte[] result = new byte[ivBytes.length + cipherBA.length];
        System.arraycopy(ivBytes, 0, result, 0, ivBytes.length);
        System.arraycopy(cipherBA, 0, result, ivBytes.length, cipherBA.length);
        return result;
    }

    @Generated
    public AesGcm(int ivSize, int tagSize) {
        this.ivSize = ivSize;
        this.tagSize = tagSize;
    }
}

