/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.certificate;

import de.gematik.bbriccs.crypto.certificate.Oid;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import javax.naming.ldap.LdapName;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

public class X509CertificateWrapper {
    private final X509CertificateHolder certHolder;
    private final X509Certificate cert;

    public X509CertificateWrapper(X509Certificate cert) {
        this.cert = cert;
        this.certHolder = new X509CertificateHolder(cert.getEncoded());
    }

    public static X509CertificateWrapper fromPem(String pem) {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8)));
        return new X509CertificateWrapper(cert);
    }

    public Optional<String> getIssuerCN() {
        String issuerX500Principal = this.cert.getIssuerX500Principal().getName();
        LdapName ldapDN = new LdapName(issuerX500Principal);
        return ldapDN.getRdns().stream().filter(it -> it.getType().equalsIgnoreCase("CN")).map(it -> it.getValue().toString()).findFirst();
    }

    private <T extends ASN1Encodable> Optional<T> getAsn1ElementByType(Iterator<ASN1Encodable> iter, Class<T> type) {
        while (iter.hasNext()) {
            ASN1Sequence seq;
            Optional<T> ret;
            ASN1Encodable element = iter.next();
            if (type.isInstance(element)) {
                return Optional.of((ASN1Encodable)type.cast(element));
            }
            if (!(element instanceof ASN1Sequence) || !(ret = this.getAsn1ElementByType((seq = (ASN1Sequence)element).iterator(), type)).isPresent()) continue;
            return ret;
        }
        return Optional.empty();
    }

    public Optional<String> getProfessionId() {
        ASN1Sequence valueIsIsMttAdmission = (ASN1Sequence)this.certHolder.getExtension(ISISMTTObjectIdentifiers.id_isismtt_at_admission).getParsedValue();
        return this.getAsn1ElementByType(valueIsIsMttAdmission.iterator(), ASN1PrintableString.class).map(ASN1PrintableString::getString);
    }

    public boolean isRsaEncryption() {
        return this.certHolder.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId().equals(PKCSObjectIdentifiers.rsaEncryption.getId());
    }

    public Optional<Oid> getCertificateTypeOid() {
        CertificatePolicies policies = CertificatePolicies.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])this.cert.getExtensionValue("2.5.29.32")));
        return Arrays.stream(policies.getPolicyInformation()).map(p -> p.getPolicyIdentifier().toString()).map(Oid::getByOid).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public X509CertificateHolder toCertificateHolder() {
        return this.certHolder;
    }

    public X509Certificate toCertificate() {
        return this.cert;
    }
}

