/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.encryption;

import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.crypto.encryption.Ecies;
import de.gematik.bbriccs.crypto.exceptions.EncryptionException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class EciesTest {
    private static KeyPair keyPair;
    private static Ecies ecies;

    @BeforeAll
    public static void setup() {
        ecies = new Ecies(1, "empty".getBytes(StandardCharsets.UTF_8), 12, 16, "brainpoolP256r1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", BC.getSecurityProvider());
        keyPairGenerator.initialize(new ECGenParameterSpec(ecies.getCurve()));
        keyPair = keyPairGenerator.generateKeyPair();
    }

    @Test
    void encryptAndDecrypt() {
        byte[] encrypt = ecies.encrypt((ECPublicKey)keyPair.getPublic(), "Test".getBytes(StandardCharsets.UTF_8));
        byte[] decrypt = ecies.decrypt(keyPair.getPrivate(), encrypt);
        Assert.assertEquals((Object)"Test", (Object)new String(decrypt, StandardCharsets.UTF_8));
    }

    @Test
    void invalidVersionType() {
        byte[] encrypt = new byte[1];
        PrivateKey privateKey = keyPair.getPrivate();
        EncryptionException thrown = (EncryptionException)Assertions.assertThrows(EncryptionException.class, () -> ecies.decrypt(privateKey, encrypt));
        Assertions.assertEquals((Object)"Invalid version byte", (Object)thrown.getMessage());
    }

    @Test
    void invalidCipherTextLength() {
        byte[] encrypt = new byte[77];
        encrypt[0] = 1;
        PrivateKey privateKey = keyPair.getPrivate();
        EncryptionException thrown = (EncryptionException)Assertions.assertThrows(EncryptionException.class, () -> ecies.decrypt(privateKey, encrypt));
        Assertions.assertEquals((Object)"Ciphertext too small!", (Object)thrown.getMessage());
    }
}

