/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.certificate;

import de.gematik.bbriccs.crypto.certificate.X509CertificateWrapper;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Optional;
import javax.naming.InvalidNameException;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class X509CertificateWrapperTest {
    private static X509Certificate testCert;

    X509CertificateWrapperTest() {
    }

    @BeforeAll
    public static void setup() {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Date notBefore = new Date();
        Date notAfter = new Date(System.currentTimeMillis() + 31536000000L);
        X500Name issuer = new X500Name("CN=Issuer");
        X500Name subject = new X500Name("CN=Subject");
        BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, keyPair.getPublic());
        BasicConstraints basicConstraints = new BasicConstraints(false);
        certBuilder.addExtension(new ASN1ObjectIdentifier("2.5.29.19"), true, (ASN1Encodable)basicConstraints);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(keyPair.getPrivate());
        byte[] certBytes = certBuilder.build(signer).getEncoded();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        testCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    @Test
    void shouldProcessPEMFormat() {
        StringWriter stringWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
            pemWriter.writeObject((Object)testCert);
        }
        String pem = stringWriter.toString();
        Assertions.assertDoesNotThrow(() -> X509CertificateWrapper.fromPem((String)pem));
    }

    @Test
    void shouldThrowOnInvalidPem() {
        String pem = "hello world";
        Assertions.assertThrows(CertificateException.class, () -> X509CertificateWrapper.fromPem((String)"hello world"));
    }

    @Test
    @DisplayName(value="should return issuer CN when present")
    void shouldReturnIssuerCNWhenPresent() {
        X509Certificate mockCert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Mockito.when((Object)mockCert.getIssuerX500Principal()).thenReturn((Object)new X500Principal("CN=Test, O=Test Org, C=DE"));
        Mockito.when((Object)mockCert.getEncoded()).thenReturn((Object)testCert.getEncoded());
        X509CertificateWrapper wrapper = new X509CertificateWrapper(mockCert);
        Optional issuerCN = wrapper.getIssuerCN();
        Assertions.assertTrue((boolean)issuerCN.isPresent());
        Assertions.assertEquals((Object)"Test", issuerCN.get());
    }

    @Test
    @DisplayName(value="should throw if certificate principal contains invalid LDAP")
    void shouldThrowOnInvalidLdap() {
        X509Certificate mockCert = (X509Certificate)Mockito.mock(X509Certificate.class);
        X500Principal mockPrincipal = (X500Principal)Mockito.mock(X500Principal.class);
        Mockito.when((Object)mockCert.getIssuerX500Principal()).thenReturn((Object)mockPrincipal);
        Mockito.when((Object)mockPrincipal.getName()).thenReturn((Object)"hello world");
        Mockito.when((Object)mockCert.getEncoded()).thenReturn((Object)testCert.getEncoded());
        X509CertificateWrapper wrapper = new X509CertificateWrapper(mockCert);
        Assertions.assertThrows(InvalidNameException.class, () -> ((X509CertificateWrapper)wrapper).getIssuerCN());
    }

    @Test
    @DisplayName(value="should return empty when issuer CN not present")
    void shouldReturnEmptyWhenIssuerCNNotPresent() {
        X509Certificate mockCert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Mockito.when((Object)mockCert.getIssuerX500Principal()).thenReturn((Object)new X500Principal("O=Test Org, C=DE"));
        Mockito.when((Object)mockCert.getEncoded()).thenReturn((Object)testCert.getEncoded());
        X509CertificateWrapper wrapper = new X509CertificateWrapper(mockCert);
        Optional issuerCN = wrapper.getIssuerCN();
        Assertions.assertFalse((boolean)issuerCN.isPresent());
    }
}

