/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto.certificate;

import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.crypto.certificate.X509CertificateWrapper;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import lombok.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CertificateTest {
    private X509CertificateWrapper smcbAutEccCert;
    private X509CertificateWrapper smcbEncRsaCert;

    CertificateTest() {
    }

    @BeforeEach
    void setUp() {
        this.smcbEncRsaCert = this.loadCertificateFrom("80276883110000116873-C_HCI_ENC_R2048.p12");
        this.smcbAutEccCert = this.loadCertificateFrom("80276001011699900861-C_SMCB_AUT_E256_X509.p12");
    }

    private X509CertificateWrapper loadCertificateFrom(@NonNull String p12File) {
        if (p12File == null) {
            throw new NullPointerException("p12File is marked non-null but is null");
        }
        InputStream is = ClassLoader.getSystemResourceAsStream(p12File);
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(is, "00".toCharArray());
        String alias = ks.aliases().nextElement();
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection("00".toCharArray()));
        return new X509CertificateWrapper((X509Certificate)privateKeyEntry.getCertificate());
    }

    @Test
    void validateCertificateInformations() {
        Assertions.assertEquals((Object)"3-SMC-B-Testkarte-883110000116873", this.smcbEncRsaCert.getProfessionId().orElseThrow());
        Assertions.assertEquals((Object)Oid.OID_SMC_B_ENC, this.smcbEncRsaCert.getCertificateTypeOid().orElseThrow());
        Assertions.assertTrue((boolean)this.smcbEncRsaCert.isRsaEncryption());
        Assertions.assertNotNull((Object)this.smcbEncRsaCert.toCertificateHolder());
        Assertions.assertEquals((Object)"5-2-KH-APO-Waldesrand-01", this.smcbAutEccCert.getProfessionId().orElseThrow());
        Assertions.assertEquals((Object)Oid.OID_SMC_B_AUT, this.smcbAutEccCert.getCertificateTypeOid().orElseThrow());
        Assertions.assertFalse((boolean)this.smcbAutEccCert.isRsaEncryption());
        Assertions.assertNotNull((Object)this.smcbAutEccCert.toCertificateHolder());
    }
}

