/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.crypto;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.CryptographySpecification;
import de.gematik.bbriccs.crypto.exceptions.InvalidCryptographySpecificationException;
import de.gematik.bbriccs.crypto.exceptions.UnsupportedCryptographySystemException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CryptoSystemTest {
    CryptoSystemTest() {
    }

    static Stream<Arguments> shouldGetEccFromString() {
        return Stream.of("E256", "ECC_256", "e256", "ecc_256").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> shouldGetFromOid() {
        return Stream.of(Arguments.of((Object[])new Object[]{PKCSObjectIdentifiers.sha256WithRSAEncryption, CryptoSystem.RSA_2048}), Arguments.of((Object[])new Object[]{PKCSObjectIdentifiers.id_RSASSA_PSS, CryptoSystem.RSA_PSS_2048}), Arguments.of((Object[])new Object[]{X9ObjectIdentifiers.ecdsa_with_SHA256, CryptoSystem.ECC_256}));
    }

    static Stream<Arguments> shouldGetRsaFromString() {
        return Stream.of("R2048", "RSA_2048", "r2048", "rsa_2048").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> shouldGetRsaPssFromString() {
        return Stream.of("RSASSA_PSS", "RSASSA-PSS").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> shouldThrowOnInvalidString() {
        return Stream.of("Ecc256", "ECC_512", "r256", "rsa_256").map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> shouldThrowOnUnsupportedOid() {
        return Stream.of(Arguments.of((Object[])new Object[]{X9ObjectIdentifiers.cTwoCurve}), Arguments.of((Object[])new Object[]{X9ObjectIdentifiers.ecdsa_with_SHA384}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldGetRsaFromString(String input) {
        Assertions.assertEquals((Object)CryptoSystem.RSA_2048, (Object)CryptoSystem.fromString((String)input));
    }

    @ParameterizedTest
    @MethodSource
    void shouldGetEccFromString(String input) {
        Assertions.assertEquals((Object)CryptoSystem.ECC_256, (Object)CryptoSystem.fromString((String)input));
    }

    @ParameterizedTest
    @MethodSource
    void shouldGetFromOid(ASN1ObjectIdentifier oid, CryptoSystem expected) {
        CryptoSystem actual = (CryptoSystem)Assertions.assertDoesNotThrow(() -> CryptoSystem.fromOid((ASN1ObjectIdentifier)oid));
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @ParameterizedTest
    @MethodSource
    void shouldThrowOnUnsupportedOid(ASN1ObjectIdentifier oid) {
        Assertions.assertThrows(UnsupportedCryptographySystemException.class, () -> CryptoSystem.fromOid((ASN1ObjectIdentifier)oid));
    }

    @ParameterizedTest
    @MethodSource
    void shouldGetRsaPssFromString(String input) {
        Assertions.assertEquals((Object)CryptoSystem.RSA_PSS_2048, (Object)CryptoSystem.fromString((String)input));
    }

    @ParameterizedTest
    @MethodSource
    void shouldThrowOnInvalidString(String input) {
        Assertions.assertThrows(UnsupportedCryptographySystemException.class, () -> CryptoSystem.fromString((String)input));
    }

    @Test
    void fromSpecificationUrn() {
        Arrays.stream(CryptographySpecification.values()).forEach(it -> Assertions.assertDoesNotThrow(() -> CryptoSystem.fromSpecificationUrn((String)it.getUrn())));
    }

    @Test
    void shouldThrowInvalidCryptographySpecificationException() {
        Assertions.assertThrows(InvalidCryptographySpecificationException.class, () -> CryptoSystem.fromSpecificationUrn((String)"urn:unknown"));
    }
}

