/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards.cli.cmd;

import de.gematik.bbriccs.cli.param.InputDirectoryParameter;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.exceptions.InvalidSmartcardTypeException;
import java.io.File;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Show Smartcards Archive"}, mixinStandardHelpOptions=true)
public class ShowSmartcards
implements Callable<Integer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShowSmartcards.class);
    @CommandLine.Mixin
    protected InputDirectoryParameter inputDirectory;
    @CommandLine.Option(names={"--type"}, paramLabel="<TYPE>", type={SmartcardType.class}, description={"Type of Smartcard to show ${COMPLETION-CANDIDATES} (default=${DEFAULT-VALUE})"})
    protected SmartcardType smartcardType = SmartcardType.EGK;

    @Override
    public Integer call() {
        SmartcardArchive sca = SmartcardArchive.from((File)this.inputDirectory.getInputPath().toFile());
        BiFunction<SmartcardArchive, String, Smartcard> constructor = this.createConstructorForType();
        sca.getICCSNsFor(this.smartcardType).forEach(iccsn -> {
            Smartcard smartcard = (Smartcard)constructor.apply(sca, (String)iccsn);
            this.printSmartcardInformation(smartcard);
        });
        return 0;
    }

    private void printSmartcardInformation(Smartcard smartcard) {
        SmartcardOwnerData ownerData = smartcard.getOwnerData();
        System.out.println(MessageFormat.format("{0} (ICSSN: {1})", smartcard.getType(), smartcard.getIccsn()));
        System.out.println(MessageFormat.format("Owner: {0} ({1} {2})", ownerData.getCommonName(), ownerData.getSurname(), ownerData.getGivenName()));
        System.out.println(MessageFormat.format("\tOrganization:\t{0}", ownerData.getOrganization()));
        System.out.println(MessageFormat.format("\tOrg. Units:\t\t{0}", ownerData.getOrganizationUnit()));
        System.out.println(MessageFormat.format("\tLocality:\t\t{0}", ownerData.getLocality()));
        System.out.println(MessageFormat.format("\tAddress:\t\t{0} {1} {2} {3}", ownerData.getCountry(), ownerData.getPostalCode(), ownerData.getLocality(), ownerData.getStreet()));
        SmartcardCertificate authCertificate = smartcard.getAutCertificate();
        System.out.println(MessageFormat.format("Auth Certificate: {0} {1}", authCertificate.getCryptoSystem(), authCertificate));
        System.out.println(MessageFormat.format("\tAUT.OIDs:\t{0}", smartcard.getAutOids().stream().map(oid -> MessageFormat.format("{0} [{1}]", oid.getType(), oid.getValue())).collect(Collectors.joining(", "))));
        System.out.println(MessageFormat.format("\tPrivateKey:\t{0}", smartcard.getPrivateKeyBase64()));
        System.out.println(MessageFormat.format("\tPublicKey:\t{0}", Base64.getEncoder().encodeToString(smartcard.getAuthPublicKey().getEncoded())));
        System.out.println("--------------");
    }

    private BiFunction<SmartcardArchive, String, Smartcard> createConstructorForType() {
        return switch (this.smartcardType) {
            case SmartcardType.EGK -> SmartcardArchive::getEgkByICCSN;
            case SmartcardType.SMC_B -> SmartcardArchive::getSmcbByICCSN;
            case SmartcardType.HBA -> SmartcardArchive::getHbaByICCSN;
            default -> throw new InvalidSmartcardTypeException(this.smartcardType);
        };
    }
}

