/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards.cli.cmd;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.gematik.bbriccs.cli.param.InputOutputDirectoryParameter;
import de.gematik.bbriccs.cli.utils.FileWalker;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.bbriccs.smartcards.HbaP12;
import de.gematik.bbriccs.smartcards.KeystoreType;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.SmartcardCertificateP12;
import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.SmcBP12;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.SmartcardFactoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="archive", description={"Create Smartcards Archive for usage with smartcards-brick"}, mixinStandardHelpOptions=true)
public class ArchiveSmartcards
implements Callable<Integer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchiveSmartcards.class);
    private static final Pattern ICCSN_PATTERN = Pattern.compile("^(\\d{15,20})$");
    @CommandLine.Mixin
    protected InputOutputDirectoryParameter inputOutputDirectory;

    @Override
    public Integer call() throws Exception {
        log.info("Archive Smartcards from {}", (Object)this.inputOutputDirectory.getInputDirectory().toString());
        LinkedList configs = new LinkedList();
        this.walkSmartcardsDirectory("egk", SmartcardType.EGK, this::createEGKConfig).stream().collect(Collectors.toCollection(() -> configs));
        this.walkSmartcardsDirectory("smcb", SmartcardType.SMC_B, this::createSmcbConfig).stream().collect(Collectors.toCollection(() -> configs));
        this.walkSmartcardsDirectory("hba", SmartcardType.HBA, this::createHBAConfig).stream().collect(Collectors.toCollection(() -> configs));
        ObjectWriter om = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).writerWithDefaultPrettyPrinter();
        String out = om.writeValueAsString(configs);
        this.inputOutputDirectory.writeFile("smartcards.json", out);
        return 0;
    }

    private List<SmartcardConfigDto> walkSmartcardsDirectory(String dirName, SmartcardType type, Function<Path, SmartcardConfigDto> creator) {
        Path basePath = this.inputOutputDirectory.getInputDirectory().resolve(dirName);
        if (this.isWalkableDirectory(basePath)) {
            FileWalker smartcardWalker = new FileWalker(basePath, false);
            List smartcardDirs = smartcardWalker.find(FileWalker.WalkType.DIRECTORIES);
            return smartcardDirs.stream().map(creator).toList();
        }
        log.warn(MessageFormat.format("Directory {0} is not walkable: no {1}-Smartcards will be read", basePath.toAbsolutePath(), type.name()));
        return List.of();
    }

    private SmartcardConfigDto createEGKConfig(Path path) {
        Pair<List<SmartcardCertificate>, SmartcardConfigDto> readCertificates = this.readCertificates(path);
        SmartcardConfigDto dto = (SmartcardConfigDto)readCertificates.getRight();
        dto.setType(SmartcardType.EGK);
        List certificates = (List)readCertificates.getLeft();
        EgkP12 egk = new EgkP12(dto, certificates);
        SmartcardOwnerData owner = egk.getOwnerData();
        dto.setIdentifier(egk.getKvnr());
        dto.setOwnerName(owner.getCommonName());
        return dto;
    }

    private SmartcardConfigDto createSmcbConfig(Path path) {
        Pair<List<SmartcardCertificate>, SmartcardConfigDto> readCertificates = this.readCertificates(path);
        SmartcardConfigDto dto = (SmartcardConfigDto)readCertificates.getRight();
        dto.setType(SmartcardType.SMC_B);
        List certificates = (List)readCertificates.getLeft();
        SmcBP12 smcB = new SmcBP12(dto, certificates);
        SmartcardOwnerData owner = smcB.getOwnerData();
        dto.setOwnerName(owner.getCommonName());
        return dto;
    }

    private SmartcardConfigDto createHBAConfig(Path path) {
        Pair<List<SmartcardCertificate>, SmartcardConfigDto> readCertificates = this.readCertificates(path);
        SmartcardConfigDto dto = (SmartcardConfigDto)readCertificates.getRight();
        dto.setType(SmartcardType.HBA);
        List certificates = (List)readCertificates.getLeft();
        HbaP12 hba = new HbaP12(dto, certificates);
        SmartcardOwnerData owner = hba.getOwnerData();
        dto.setOwnerName(owner.getCommonName());
        return dto;
    }

    private Pair<List<SmartcardCertificate>, SmartcardConfigDto> readCertificates(Path path) {
        log.info("Read Certificates from: {}", (Object)path.toAbsolutePath());
        FileWalker walker = new FileWalker(path, true);
        SmartcardConfigDto dto = new SmartcardConfigDto();
        String iccsn = path.toFile().getName();
        if (!ICCSN_PATTERN.matcher(iccsn).matches()) {
            throw new IllegalArgumentException(MessageFormat.format("Convention violation: given diretory does not conform ICCSN structure: {0}", path.toAbsolutePath()));
        }
        List<File> certificateFiles = walker.find(FileWalker.WalkType.FILES).stream().map(Path::toFile).filter(fp -> fp.getName().endsWith(KeystoreType.P12.getFileExtension())).toList();
        List<SmartcardCertificate> certificates = certificateFiles.stream().map(f -> {
            Supplier<InputStream> fiss = () -> {
                try {
                    return Files.newInputStream(f.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new SmartcardFactoryException(MessageFormat.format("Unable to load File from {0}", f), (Throwable)e);
                }
            };
            return new SmartcardCertificateP12(f.getPath(), fiss);
        }).toList();
        dto.setIccsn(iccsn);
        dto.setStores(certificateFiles.stream().map(fp -> this.createRelativePath(path.getParent().getParent(), (File)fp)).toList());
        return Pair.of(certificates, (Object)dto);
    }

    private boolean isWalkableDirectory(Path path) {
        File f = path.toFile();
        return f.exists() && f.isDirectory() && f.canRead();
    }

    private String createRelativePath(Path base, File certificateFile) {
        return base.relativize(certificateFile.toPath()).toString();
    }
}

