/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards.cli.cmd;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.bbriccs.cli.param.InputOutputDirectoryParameter;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import de.gematik.bbriccs.smartcards.SmartcardType;
import java.io.File;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="adv", description={"Transform Smartcards Archive to AdV-Smartcards"}, mixinStandardHelpOptions=true)
public class AdvSmartcards
implements Callable<Integer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdvSmartcards.class);
    @CommandLine.Mixin
    protected InputOutputDirectoryParameter inputOutputDirectory;

    @Override
    public Integer call() throws Exception {
        SmartcardArchive sca = SmartcardArchive.from((File)this.inputOutputDirectory.getInputPath().toFile());
        List<VEgk> vegks = sca.getICCSNsFor(SmartcardType.EGK).stream().map(iccsn -> {
            Egk smartcard = sca.getEgkByICCSN(iccsn);
            return this.transformTo(smartcard);
        }).toList();
        ObjectMapper om = new ObjectMapper();
        String out = om.writerWithDefaultPrettyPrinter().writeValueAsString(vegks);
        System.out.println(out);
        return 0;
    }

    private VEgk transformTo(Egk egk) {
        VEgk vegk = new VEgk();
        vegk.setIccsn(egk.getIccsn());
        vegk.setKvnr(egk.getKvnr());
        vegk.setOwner(VOwnerData.from(egk.getOwnerData()));
        VCryptoData crypto = new VCryptoData();
        crypto.setPrivateKey(egk.getPrivateKeyBase64());
        crypto.setCertificate(Base64.getEncoder().encodeToString(egk.getAutCertificate().getX509Certificate().getEncoded()));
        vegk.setCrypto(crypto);
        return vegk;
    }

    private static class VEgk {
        private String iccsn;
        private String kvnr;
        private VOwnerData owner;
        private VCryptoData crypto;

        @Generated
        public VEgk() {
        }

        @Generated
        public String getIccsn() {
            return this.iccsn;
        }

        @Generated
        public String getKvnr() {
            return this.kvnr;
        }

        @Generated
        public VOwnerData getOwner() {
            return this.owner;
        }

        @Generated
        public VCryptoData getCrypto() {
            return this.crypto;
        }

        @Generated
        public void setIccsn(String iccsn) {
            this.iccsn = iccsn;
        }

        @Generated
        public void setKvnr(String kvnr) {
            this.kvnr = kvnr;
        }

        @Generated
        public void setOwner(VOwnerData owner) {
            this.owner = owner;
        }

        @Generated
        public void setCrypto(VCryptoData crypto) {
            this.crypto = crypto;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VEgk)) {
                return false;
            }
            VEgk other = (VEgk)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$iccsn = this.getIccsn();
            String other$iccsn = other.getIccsn();
            if (this$iccsn == null ? other$iccsn != null : !this$iccsn.equals(other$iccsn)) {
                return false;
            }
            String this$kvnr = this.getKvnr();
            String other$kvnr = other.getKvnr();
            if (this$kvnr == null ? other$kvnr != null : !this$kvnr.equals(other$kvnr)) {
                return false;
            }
            VOwnerData this$owner = this.getOwner();
            VOwnerData other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
                return false;
            }
            VCryptoData this$crypto = this.getCrypto();
            VCryptoData other$crypto = other.getCrypto();
            return !(this$crypto == null ? other$crypto != null : !((Object)this$crypto).equals(other$crypto));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VEgk;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $iccsn = this.getIccsn();
            result = result * 59 + ($iccsn == null ? 43 : $iccsn.hashCode());
            String $kvnr = this.getKvnr();
            result = result * 59 + ($kvnr == null ? 43 : $kvnr.hashCode());
            VOwnerData $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
            VCryptoData $crypto = this.getCrypto();
            result = result * 59 + ($crypto == null ? 43 : ((Object)$crypto).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdvSmartcards.VEgk(iccsn=" + this.getIccsn() + ", kvnr=" + this.getKvnr() + ", owner=" + String.valueOf(this.getOwner()) + ", crypto=" + String.valueOf(this.getCrypto()) + ")";
        }
    }

    private static class VOwnerData {
        private String firstName;
        private String lastName;

        public static VOwnerData from(SmartcardOwnerData sod) {
            VOwnerData vod = new VOwnerData();
            String[] nameTokens = sod.getCommonName().replace("TEST-ONLY", "").split(" ");
            String firstName = nameTokens[0];
            String lastName = nameTokens[nameTokens.length - 1];
            vod.setFirstName(firstName);
            vod.setLastName(lastName);
            return vod;
        }

        @Generated
        public VOwnerData() {
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VOwnerData)) {
                return false;
            }
            VOwnerData other = (VOwnerData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            return !(this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VOwnerData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdvSmartcards.VOwnerData(firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ")";
        }
    }

    private static class VCryptoData {
        private String privateKey;
        private String certificate;

        @Generated
        public VCryptoData() {
        }

        @Generated
        public String getPrivateKey() {
            return this.privateKey;
        }

        @Generated
        public String getCertificate() {
            return this.certificate;
        }

        @Generated
        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Generated
        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VCryptoData)) {
                return false;
            }
            VCryptoData other = (VCryptoData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$privateKey = this.getPrivateKey();
            String other$privateKey = other.getPrivateKey();
            if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
                return false;
            }
            String this$certificate = this.getCertificate();
            String other$certificate = other.getCertificate();
            return !(this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VCryptoData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            String $certificate = this.getCertificate();
            result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdvSmartcards.VCryptoData(privateKey=" + this.getPrivateKey() + ", certificate=" + this.getCertificate() + ")";
        }
    }
}

