/*
 * Copyright 2024 gematik GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.gematik.bbriccs.smartcards.cli;

import de.gematik.bbriccs.smartcards.cli.cmd.AdvSmartcards;
import de.gematik.bbriccs.smartcards.cli.cmd.ArchiveSmartcards;
import de.gematik.bbriccs.smartcards.cli.cmd.ShowSmartcards;
import lombok.AccessLevel;
import lombok.RequiredArgsConstructor;
import lombok.val;
import picocli.CommandLine;
import picocli.CommandLine.Command;

@Command(
    name = "sca",
    aliases = {"sca-cli"},
    description = "Smartcards Archiver Utility",
    mixinStandardHelpOptions = true,
    subcommands = {ArchiveSmartcards.class, ShowSmartcards.class, AdvSmartcards.class})
@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public class SmartcardsApp {

  public static void main(String[] args) {
    val topLevelCommand =
        new CommandLine(new SmartcardsApp())
            .setSubcommandsCaseInsensitive(true)
            .setCaseInsensitiveEnumValuesAllowed(true)
            .setAbbreviatedSubcommandsAllowed(true)
            .setColorScheme(CommandLine.Help.defaultColorScheme(CommandLine.Help.Ansi.AUTO));

    var exitCode = topLevelCommand.execute(args);
    System.exit(exitCode);
  }
}
