/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.cardterminal.cfg;

import de.gematik.bbriccs.cardterminal.CardTerminalFactoryService;
import de.gematik.bbriccs.cardterminal.cfg.CardTerminalConfiguration;
import de.gematik.bbriccs.cardterminal.exceptions.InvalidCardTerminalConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CardTerminalConfigurationTest {
    CardTerminalConfigurationTest() {
    }

    @Test
    void shouldCastProperly() {
        FirstCardTerminalConfiguration cardTerminalConfiguration = new FirstCardTerminalConfiguration();
        Assertions.assertDoesNotThrow(() -> (FirstCardTerminalConfiguration)cardTerminalConfiguration.castTo((CardTerminalFactoryService)Mockito.mock(CardTerminalFactoryService.class), FirstCardTerminalConfiguration.class));
    }

    @Test
    void shouldThrowOnInvalidCardTerminalConfiguration() {
        FirstCardTerminalConfiguration cardTerminalConfiguration = new FirstCardTerminalConfiguration();
        Assertions.assertThrows(InvalidCardTerminalConfigurationException.class, () -> cardTerminalConfiguration.castTo((CardTerminalFactoryService)Mockito.mock(CardTerminalFactoryService.class), SecondCardTerminalConfiguration.class));
    }

    private static class FirstCardTerminalConfiguration
    extends CardTerminalConfiguration {
        private FirstCardTerminalConfiguration() {
        }

        public String getType() {
            return "first";
        }
    }

    private static class SecondCardTerminalConfiguration
    extends CardTerminalConfiguration {
        private SecondCardTerminalConfiguration() {
        }

        public String getType() {
            return "second";
        }
    }
}

