/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.cardterminal;

import de.gematik.bbriccs.cardterminal.CardTerminal;
import de.gematik.bbriccs.cardterminal.CardTerminalOperator;
import de.gematik.bbriccs.cardterminal.exceptions.NoFreeSlotException;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CardTerminalOperatorTest {
    CardTerminalOperatorTest() {
    }

    @Test
    void shouldInsertSmartcard() {
        SmartcardArchive sca = SmartcardArchive.fromResources();
        CardTerminal cardTerminal = (CardTerminal)Mockito.mock(CardTerminal.class);
        Mockito.when((Object)cardTerminal.hasFreeSlot()).thenReturn((Object)true);
        Egk egk = sca.getEgk(0);
        CardTerminalOperator operator = new CardTerminalOperator(List.of(cardTerminal));
        Assertions.assertDoesNotThrow(() -> operator.insertCard((Smartcard)egk));
    }

    @Test
    void shouldThrowOnNoFreeSlots() {
        SmartcardArchive sca = SmartcardArchive.fromResources();
        CardTerminal cardTerminal1 = (CardTerminal)Mockito.mock(CardTerminal.class);
        Mockito.when((Object)cardTerminal1.hasFreeSlot()).thenReturn((Object)false);
        CardTerminal cardTerminal2 = (CardTerminal)Mockito.mock(CardTerminal.class);
        Mockito.when((Object)cardTerminal2.hasFreeSlot()).thenReturn((Object)false);
        Egk egk = sca.getEgk(0);
        CardTerminalOperator operator = new CardTerminalOperator(List.of(cardTerminal1, cardTerminal2));
        Assertions.assertThrows(NoFreeSlotException.class, () -> operator.insertCard((Smartcard)egk));
    }

    @Test
    void shouldThrowOnNoFreeSlotsBecauseOfNoCardTerminals() {
        SmartcardArchive sca = SmartcardArchive.fromResources();
        CardTerminalOperator operator = new CardTerminalOperator(List.of());
        Egk egk = sca.getEgk(0);
        Assertions.assertThrows(NoFreeSlotException.class, () -> operator.insertCard((Smartcard)egk));
    }
}

