/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.utils.dto;

import de.gematik.bbriccs.utils.dto.RootCertificateAuthorityDto;
import de.gematik.bbriccs.utils.exceptions.MissingRootCertificateAuthorityNumber;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\b\u0010\f\u001a\u00020\tH\u0007J\b\u0010\r\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/gematik/bbriccs/utils/dto/RootCertificateAuthorityDtoTest;", "", "<init>", "()V", "certificate", "Ljava/security/cert/X509Certificate;", "rootCertificateAuthorityDto", "Lde/gematik/bbriccs/utils/dto/RootCertificateAuthorityDto;", "setup", "", "isCrossCa should return true when url contains CROSS", "isCrossCa should return false when url does not contain CROSS", "getCaNumber should return correct number when CN contains digits", "getCaNumber should return 0 when CN does not contain digits", "ca-supplier-brick"})
public final class RootCertificateAuthorityDtoTest {
    private X509Certificate certificate;
    private RootCertificateAuthorityDto rootCertificateAuthorityDto;

    @BeforeEach
    public final void setup() {
        this.certificate = (X509Certificate)Mockito.mock(X509Certificate.class);
        X509Certificate x509Certificate = this.certificate;
        if (x509Certificate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificate");
            x509Certificate = null;
        }
        this.rootCertificateAuthorityDto = new RootCertificateAuthorityDto(x509Certificate, "http://test.url");
    }

    @Test
    public final void isCrossCa should return true when url contains CROSS() {
        RootCertificateAuthorityDto rootCertificateAuthorityDto;
        X509Certificate x509Certificate = this.certificate;
        if (x509Certificate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificate");
            x509Certificate = null;
        }
        if ((rootCertificateAuthorityDto = (this.rootCertificateAuthorityDto = new RootCertificateAuthorityDto(x509Certificate, "http://GEM.RCA3_TEST-ONLY-CROSS-GEM.RCA4_TEST-ONLY.der"))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCertificateAuthorityDto");
            rootCertificateAuthorityDto = null;
        }
        boolean isCrossCa = rootCertificateAuthorityDto.isCrossCa();
        Assertions.assertTrue((boolean)isCrossCa);
    }

    @Test
    public final void isCrossCa should return false when url does not contain CROSS() {
        RootCertificateAuthorityDto rootCertificateAuthorityDto = this.rootCertificateAuthorityDto;
        if (rootCertificateAuthorityDto == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCertificateAuthorityDto");
            rootCertificateAuthorityDto = null;
        }
        boolean isCrossCa = rootCertificateAuthorityDto.isCrossCa();
        Assertions.assertFalse((boolean)isCrossCa);
    }

    @Test
    public final void getCaNumber should return correct number when CN contains digits() {
        X509Certificate x509Certificate = this.certificate;
        if (x509Certificate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificate");
            x509Certificate = null;
        }
        Mockito.when((Object)x509Certificate.getSubjectX500Principal()).thenReturn((Object)new X500Principal("CN=GEM.RCA7 TEST-ONLY"));
        RootCertificateAuthorityDto rootCertificateAuthorityDto = this.rootCertificateAuthorityDto;
        if (rootCertificateAuthorityDto == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCertificateAuthorityDto");
            rootCertificateAuthorityDto = null;
        }
        int caNumber = rootCertificateAuthorityDto.getCaNumber();
        Assertions.assertEquals((int)7, (int)caNumber);
    }

    @Test
    public final void getCaNumber should return 0 when CN does not contain digits() {
        X509Certificate x509Certificate = this.certificate;
        if (x509Certificate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificate");
            x509Certificate = null;
        }
        Mockito.when((Object)x509Certificate.getSubjectX500Principal()).thenReturn((Object)new X500Principal("CN=TestSubject"));
        Assertions.assertThrows(MissingRootCertificateAuthorityNumber.class, () -> RootCertificateAuthorityDtoTest.getCaNumber_should_return_0_when_CN_does_not_contain_digits$lambda$0(this));
    }

    private static final void getCaNumber_should_return_0_when_CN_does_not_contain_digits$lambda$0(RootCertificateAuthorityDtoTest this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RootCertificateAuthorityDto rootCertificateAuthorityDto = this$0.rootCertificateAuthorityDto;
        if (rootCertificateAuthorityDto == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCertificateAuthorityDto");
            rootCertificateAuthorityDto = null;
        }
        rootCertificateAuthorityDto.getCaNumber();
    }
}

