/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.utils.dto;

import de.gematik.bbriccs.utils.dto.CertificateAuthorityDto;
import de.gematik.bbriccs.utils.exceptions.MissingCertificateAuthorityIssuer;
import de.gematik.bbriccs.utils.exceptions.MissingCertificateAuthoritySubject;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\b\u0010\f\u001a\u00020\tH\u0007J\b\u0010\r\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/gematik/bbriccs/utils/dto/CertificateAuthorityDtoTest;", "", "<init>", "()V", "certificate", "Ljava/security/cert/X509Certificate;", "certificateAuthorityDto", "Lde/gematik/bbriccs/utils/dto/CertificateAuthorityDto;", "setup", "", "getSubjectCN should return correct CN", "getIssuerCN should return correct CN", "getSubjectCN should throw MissingCertificateAuthoritySubject when CN is missing", "getIssuerCN should throw MissingCertificateAuthorityIssuer when CN is missing", "ca-supplier-brick"})
public final class CertificateAuthorityDtoTest {
    private X509Certificate certificate;
    private CertificateAuthorityDto certificateAuthorityDto;

    @BeforeEach
    public final void setup() {
        this.certificate = (X509Certificate)Mockito.mock(X509Certificate.class);
        X509Certificate x509Certificate = this.certificate;
        if (x509Certificate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificate");
            x509Certificate = null;
        }
        this.certificateAuthorityDto = new CertificateAuthorityDto(x509Certificate, "http://test.url");
    }

    @Test
    public final void getSubjectCN should return correct CN() {
        X509Certificate x509Certificate = this.certificate;
        if (x509Certificate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificate");
            x509Certificate = null;
        }
        Mockito.when((Object)x509Certificate.getSubjectX500Principal()).thenReturn((Object)new X500Principal("CN=Test Subject"));
        CertificateAuthorityDto certificateAuthorityDto = this.certificateAuthorityDto;
        if (certificateAuthorityDto == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificateAuthorityDto");
            certificateAuthorityDto = null;
        }
        String subjectCN = certificateAuthorityDto.getSubjectCN();
        Assertions.assertEquals((Object)"Test Subject", (Object)subjectCN);
    }

    @Test
    public final void getIssuerCN should return correct CN() {
        X509Certificate x509Certificate = this.certificate;
        if (x509Certificate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificate");
            x509Certificate = null;
        }
        Mockito.when((Object)x509Certificate.getIssuerX500Principal()).thenReturn((Object)new X500Principal("CN=Test Issuer"));
        CertificateAuthorityDto certificateAuthorityDto = this.certificateAuthorityDto;
        if (certificateAuthorityDto == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificateAuthorityDto");
            certificateAuthorityDto = null;
        }
        String issuerCN = certificateAuthorityDto.getIssuerCN();
        Assertions.assertEquals((Object)"Test Issuer", (Object)issuerCN);
    }

    @Test
    public final void getSubjectCN should throw MissingCertificateAuthoritySubject when CN is missing() {
        X509Certificate x509Certificate = this.certificate;
        if (x509Certificate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificate");
            x509Certificate = null;
        }
        Mockito.when((Object)x509Certificate.getSubjectX500Principal()).thenReturn((Object)new X500Principal("O=Test Organization"));
        Assertions.assertThrows(MissingCertificateAuthoritySubject.class, () -> CertificateAuthorityDtoTest.getSubjectCN_should_throw_MissingCertificateAuthoritySubject_when_CN_is_missing$lambda$0(this));
    }

    @Test
    public final void getIssuerCN should throw MissingCertificateAuthorityIssuer when CN is missing() {
        X509Certificate x509Certificate = this.certificate;
        if (x509Certificate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificate");
            x509Certificate = null;
        }
        Mockito.when((Object)x509Certificate.getIssuerX500Principal()).thenReturn((Object)new X500Principal("O=Test Organization"));
        Assertions.assertThrows(MissingCertificateAuthorityIssuer.class, () -> CertificateAuthorityDtoTest.getIssuerCN_should_throw_MissingCertificateAuthorityIssuer_when_CN_is_missing$lambda$1(this));
    }

    private static final void getSubjectCN_should_throw_MissingCertificateAuthoritySubject_when_CN_is_missing$lambda$0(CertificateAuthorityDtoTest this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CertificateAuthorityDto certificateAuthorityDto = this$0.certificateAuthorityDto;
        if (certificateAuthorityDto == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificateAuthorityDto");
            certificateAuthorityDto = null;
        }
        certificateAuthorityDto.getSubjectCN();
    }

    private static final void getIssuerCN_should_throw_MissingCertificateAuthorityIssuer_when_CN_is_missing$lambda$1(CertificateAuthorityDtoTest this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CertificateAuthorityDto certificateAuthorityDto = this$0.certificateAuthorityDto;
        if (certificateAuthorityDto == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certificateAuthorityDto");
            certificateAuthorityDto = null;
        }
        certificateAuthorityDto.getIssuerCN();
    }
}

