/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.utils;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import de.gematik.bbriccs.rest.HttpBClient;
import de.gematik.bbriccs.rest.RestClient;
import de.gematik.bbriccs.utils.CaType;
import de.gematik.bbriccs.utils.CertificateAuthoritySupplier;
import de.gematik.bbriccs.utils.Certs;
import de.gematik.bbriccs.utils.RootCertificateAuthorityList;
import de.gematik.bbriccs.utils.TiTrustedEnvironmentAnchor;
import de.gematik.bbriccs.utils.TrustedEnvironmentAnchor;
import de.gematik.bbriccs.utils.dto.RootCertificateAuthorityDto;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007J\b\u0010\r\u001a\u00020\u000bH\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0007J\b\u0010\u000f\u001a\u00020\u000bH\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/gematik/bbriccs/utils/CertificateAuthoritySupplierTest;", "", "<init>", "()V", "rootCAs", "Lde/gematik/bbriccs/utils/RootCertificateAuthorityList;", "wireMockServer", "Lcom/github/tomakehurst/wiremock/WireMockServer;", "httpBClient", "Lde/gematik/bbriccs/rest/HttpBClient;", "setup", "", "tearDown", "getRootCAs should return correct RootCertificateAuthorityList", "getSubCAs should return correct list of CertificateAuthorityDto", "Navigation RootCertificateAuthorityList", "Builder should not throw exceptions", "Integration Test", "anchor", "Lde/gematik/bbriccs/utils/TrustedEnvironmentAnchor;", "ca-supplier-brick"})
@SourceDebugExtension(value={"SMAP\nCertificateAuthoritySupplierTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateAuthoritySupplierTest.kt\nde/gematik/bbriccs/utils/CertificateAuthoritySupplierTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,168:1\n1863#2:169\n1863#2,2:170\n1864#2:172\n1863#2:173\n1864#2:202\n1863#2:203\n1864#2:218\n1863#2:240\n1864#2:269\n166#3:174\n200#3,6:175\n166#3:181\n200#3,6:182\n166#3:188\n200#3,6:189\n166#3:195\n200#3,6:196\n166#3:204\n200#3,6:205\n166#3:211\n200#3,6:212\n166#3:219\n200#3,6:220\n166#3:226\n200#3,6:227\n166#3:233\n200#3,6:234\n166#3:241\n200#3,6:242\n166#3:248\n200#3,6:249\n166#3:255\n200#3,6:256\n166#3:262\n200#3,6:263\n*S KotlinDebug\n*F\n+ 1 CertificateAuthoritySupplierTest.kt\nde/gematik/bbriccs/utils/CertificateAuthoritySupplierTest\n*L\n51#1:169\n61#1:170,2\n51#1:172\n83#1:173\n83#1:202\n94#1:203\n94#1:218\n137#1:240\n137#1:269\n84#1:174\n84#1:175,6\n85#1:181\n85#1:182,6\n86#1:188\n86#1:189,6\n87#1:195\n87#1:196,6\n95#1:204\n95#1:205,6\n96#1:211\n96#1:212,6\n127#1:219\n127#1:220,6\n128#1:226\n128#1:227,6\n129#1:233\n129#1:234,6\n138#1:241\n138#1:242,6\n139#1:248\n139#1:249,6\n140#1:255\n140#1:256,6\n141#1:262\n141#1:263,6\n*E\n"})
public final class CertificateAuthoritySupplierTest {
    private RootCertificateAuthorityList rootCAs;
    private WireMockServer wireMockServer;
    private HttpBClient httpBClient;

    @BeforeEach
    public final void setup() {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        WireMockServer wireMockServer = this.wireMockServer;
        if (wireMockServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wireMockServer");
            wireMockServer = null;
        }
        wireMockServer.start();
        StringBuilder stringBuilder = new StringBuilder().append("http://localhost:");
        WireMockServer wireMockServer2 = this.wireMockServer;
        if (wireMockServer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wireMockServer");
            wireMockServer2 = null;
        }
        this.httpBClient = (HttpBClient)RestClient.forUrl((String)stringBuilder.append(wireMockServer2.port()).toString()).withoutTlsVerification();
        Iterable $this$forEach$iv = (Iterable)CaType.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CaType it = (CaType)element$iv;
            boolean bl = false;
            WireMockServer wireMockServer3 = this.wireMockServer;
            if (wireMockServer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wireMockServer");
                wireMockServer3 = null;
            }
            wireMockServer3.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)("/ECC/" + it + '/'))).willReturn(WireMock.aResponse().withStatus(200).withBody(CollectionsKt.joinToString$default((Iterable)Certs.Companion.getRootCAs(), (CharSequence)" ", null, null, (int)0, null, CertificateAuthoritySupplierTest::setup$lambda$2$lambda$0, (int)30, null))));
            Iterable $this$forEach$iv2 = Certs.Companion.getRootCAs();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Certs cert = (Certs)((Object)element$iv2);
                boolean bl2 = false;
                WireMockServer wireMockServer4 = this.wireMockServer;
                if (wireMockServer4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"wireMockServer");
                    wireMockServer4 = null;
                }
                wireMockServer4.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)("/ECC/" + it + '/' + cert.getCaName() + ".der"))).willReturn(WireMock.aResponse().withStatus(200).withBody(cert.getCert().getEncoded())));
            }
        }
        CertificateAuthoritySupplier.Builder builder = CertificateAuthoritySupplier.Companion.builder();
        HttpBClient httpBClient = this.httpBClient;
        if (httpBClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"httpBClient");
            httpBClient = null;
        }
        this.rootCAs = builder.useHttpClient(httpBClient).getRootCAsFromBackend();
    }

    @AfterEach
    public final void tearDown() {
        WireMockServer wireMockServer = this.wireMockServer;
        if (wireMockServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wireMockServer");
            wireMockServer = null;
        }
        wireMockServer.stop();
    }

    @Test
    public final void getRootCAs should return correct RootCertificateAuthorityList() {
        RootCertificateAuthorityList rootCertificateAuthorityList = this.rootCAs;
        if (rootCertificateAuthorityList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList = null;
        }
        Iterable $this$forEach$iv = (Iterable)rootCertificateAuthorityList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThrowingSupplier throwingSupplier;
            Object result$iv$iv;
            RootCertificateAuthorityDto ca = (RootCertificateAuthorityDto)element$iv;
            boolean bl = false;
            boolean $i$f$assertDoesNotThrow = false;
            boolean $i$f$evaluateAndWrap = false;
            try {
                boolean bl2 = false;
                result$iv$iv = ca.getSubjectCN();
                result$iv$iv = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final String get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                result$iv$iv = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)result$iv$iv);
            $i$f$assertDoesNotThrow = false;
            $i$f$evaluateAndWrap = false;
            try {
                boolean bl3 = false;
                result$iv$iv = ca.getIssuerCN();
                result$iv$iv = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final String get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                result$iv$iv = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)result$iv$iv);
            $i$f$assertDoesNotThrow = false;
            $i$f$evaluateAndWrap = false;
            try {
                boolean bl4 = false;
                result$iv$iv = ca.getCaNumber();
                result$iv$iv = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final Integer get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                result$iv$iv = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)result$iv$iv);
            $i$f$assertDoesNotThrow = false;
            $i$f$evaluateAndWrap = false;
            try {
                boolean bl5 = false;
                result$iv$iv = ca.isCrossCa();
                throwingSupplier = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final Boolean get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                throwingSupplier = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)throwingSupplier);
            Assertions.assertNotNull((Object)ca.getCert());
        }
    }

    @Test
    public final void getSubCAs should return correct list of CertificateAuthorityDto() {
        RootCertificateAuthorityList rootCertificateAuthorityList = this.rootCAs;
        if (rootCertificateAuthorityList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList = null;
        }
        Iterable $this$forEach$iv = (Iterable)rootCertificateAuthorityList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThrowingSupplier throwingSupplier;
            String result$iv$iv;
            RootCertificateAuthorityDto ca = (RootCertificateAuthorityDto)element$iv;
            boolean bl = false;
            boolean $i$f$assertDoesNotThrow = false;
            boolean $i$f$evaluateAndWrap = false;
            try {
                boolean bl2 = false;
                result$iv$iv = ca.getSubjectCN();
                result$iv$iv = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final String get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                result$iv$iv = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)result$iv$iv);
            $i$f$assertDoesNotThrow = false;
            $i$f$evaluateAndWrap = false;
            try {
                boolean bl3 = false;
                result$iv$iv = ca.getIssuerCN();
                throwingSupplier = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final String get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                throwingSupplier = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)throwingSupplier);
            Assertions.assertNotNull((Object)ca.getCert());
        }
    }

    @Test
    public final void Navigation RootCertificateAuthorityList() {
        RootCertificateAuthorityList rootCertificateAuthorityList = this.rootCAs;
        if (rootCertificateAuthorityList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList = null;
        }
        RootCertificateAuthorityDto rootCertificateAuthorityDto = rootCertificateAuthorityList.getRootCABy(Certs.CA5.getSubjectCN());
        if (rootCertificateAuthorityDto == null) {
            throw new AssertionError((Object)"CA5 not found");
        }
        RootCertificateAuthorityDto ca5 = rootCertificateAuthorityDto;
        RootCertificateAuthorityList rootCertificateAuthorityList2 = this.rootCAs;
        if (rootCertificateAuthorityList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList2 = null;
        }
        RootCertificateAuthorityDto rootCertificateAuthorityDto2 = rootCertificateAuthorityList2.getRootCABy(Certs.CA6.getSubjectCN());
        if (rootCertificateAuthorityDto2 == null) {
            throw new AssertionError((Object)"CA6 not found");
        }
        RootCertificateAuthorityDto ca6 = rootCertificateAuthorityDto2;
        RootCertificateAuthorityList rootCertificateAuthorityList3 = this.rootCAs;
        if (rootCertificateAuthorityList3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList3 = null;
        }
        RootCertificateAuthorityDto ca62Ca5 = (RootCertificateAuthorityDto)CollectionsKt.first((Iterable)rootCertificateAuthorityList3.getCurrentCrossRootCAs(ca5));
        RootCertificateAuthorityList rootCertificateAuthorityList4 = this.rootCAs;
        if (rootCertificateAuthorityList4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList4 = null;
        }
        RootCertificateAuthorityDto ca52Ca6 = (RootCertificateAuthorityDto)CollectionsKt.first((Iterable)rootCertificateAuthorityList4.getCurrentCrossRootCAs(ca6));
        RootCertificateAuthorityList rootCertificateAuthorityList5 = this.rootCAs;
        if (rootCertificateAuthorityList5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList5 = null;
        }
        Assertions.assertEquals((Object)ca6, (Object)rootCertificateAuthorityList5.nextRootCA(ca5));
        RootCertificateAuthorityList rootCertificateAuthorityList6 = this.rootCAs;
        if (rootCertificateAuthorityList6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList6 = null;
        }
        Assertions.assertEquals((Object)ca5, (Object)rootCertificateAuthorityList6.beforeRootCA(ca6));
        RootCertificateAuthorityList rootCertificateAuthorityList7 = this.rootCAs;
        if (rootCertificateAuthorityList7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList7 = null;
        }
        Set it = rootCertificateAuthorityList7.getChainOfCrossRootCAs(ca5, ca6);
        boolean bl = false;
        Assertions.assertEquals((int)1, (int)it.size());
        Assertions.assertEquals((Object)ca62Ca5, (Object)CollectionsKt.first((Iterable)it));
        RootCertificateAuthorityList rootCertificateAuthorityList8 = this.rootCAs;
        if (rootCertificateAuthorityList8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList8 = null;
        }
        it = rootCertificateAuthorityList8.getChainOfCrossRootCAs(ca6, ca5);
        boolean bl2 = false;
        Assertions.assertEquals((int)1, (int)it.size());
        Assertions.assertEquals((Object)ca52Ca6, (Object)CollectionsKt.first((Iterable)it));
        RootCertificateAuthorityList rootCertificateAuthorityList9 = this.rootCAs;
        if (rootCertificateAuthorityList9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootCAs");
            rootCertificateAuthorityList9 = null;
        }
        Object[] objectArray = new X509Certificate[]{Certs.KOMP_CA51.getCert(), Certs.KOMP_CA54.getCert()};
        it = rootCertificateAuthorityList9.getChainOfCrossRootCAs((Collection)CollectionsKt.listOf((Object[])objectArray), ca5);
        boolean bl3 = false;
        Assertions.assertEquals((int)1, (int)it.size());
    }

    @Test
    public final void Builder should not throw exceptions() {
        ThrowingSupplier throwingSupplier;
        CertificateAuthoritySupplier.Builder result$iv$iv;
        boolean $i$f$assertDoesNotThrow = false;
        boolean $i$f$evaluateAndWrap = false;
        try {
            boolean bl = false;
            result$iv$iv = new CertificateAuthoritySupplier.Builder().useTI();
            result$iv$iv = new ThrowingSupplier(result$iv$iv){
                final /* synthetic */ Object $result;
                {
                    this.$result = object;
                }

                public final CertificateAuthoritySupplier.Builder get() {
                    return this.$result;
                }
            };
        }
        catch (Throwable throwable$iv$iv) {
            result$iv$iv = new ThrowingSupplier(throwable$iv$iv){
                final /* synthetic */ Throwable $throwable;
                {
                    this.$throwable = throwable;
                }

                @NotNull
                public final Void get() {
                    throw this.$throwable;
                }
            };
        }
        Assertions.assertDoesNotThrow((ThrowingSupplier)result$iv$iv);
        $i$f$assertDoesNotThrow = false;
        $i$f$evaluateAndWrap = false;
        try {
            boolean bl = false;
            result$iv$iv = new CertificateAuthoritySupplier.Builder().useInternet();
            result$iv$iv = new ThrowingSupplier(result$iv$iv){
                final /* synthetic */ Object $result;
                {
                    this.$result = object;
                }

                public final CertificateAuthoritySupplier.Builder get() {
                    return this.$result;
                }
            };
        }
        catch (Throwable throwable$iv$iv) {
            result$iv$iv = new ThrowingSupplier(throwable$iv$iv){
                final /* synthetic */ Throwable $throwable;
                {
                    this.$throwable = throwable;
                }

                @NotNull
                public final Void get() {
                    throw this.$throwable;
                }
            };
        }
        Assertions.assertDoesNotThrow((ThrowingSupplier)result$iv$iv);
        $i$f$assertDoesNotThrow = false;
        $i$f$evaluateAndWrap = false;
        try {
            boolean bl = false;
            result$iv$iv = new CertificateAuthoritySupplier.Builder().withEnvironmentAnchor((TrustedEnvironmentAnchor)TiTrustedEnvironmentAnchor.RU);
            throwingSupplier = new ThrowingSupplier(result$iv$iv){
                final /* synthetic */ Object $result;
                {
                    this.$result = object;
                }

                public final CertificateAuthoritySupplier.Builder get() {
                    return this.$result;
                }
            };
        }
        catch (Throwable throwable$iv$iv) {
            throwingSupplier = new ThrowingSupplier(throwable$iv$iv){
                final /* synthetic */ Throwable $throwable;
                {
                    this.$throwable = throwable;
                }

                @NotNull
                public final Void get() {
                    throw this.$throwable;
                }
            };
        }
        Assertions.assertDoesNotThrow((ThrowingSupplier)throwingSupplier);
    }

    @ParameterizedTest
    @Disabled
    @EnumSource(value=TiTrustedEnvironmentAnchor.class)
    public final void Integration Test(@NotNull TrustedEnvironmentAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        RootCertificateAuthorityList rootCAs = new CertificateAuthoritySupplier.Builder().withEnvironmentAnchor(anchor).getRootCAsFromBackend();
        Iterable $this$forEach$iv = (Iterable)rootCAs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThrowingSupplier throwingSupplier;
            Object result$iv$iv;
            RootCertificateAuthorityDto ca = (RootCertificateAuthorityDto)element$iv;
            boolean bl = false;
            boolean $i$f$assertDoesNotThrow = false;
            boolean $i$f$evaluateAndWrap = false;
            try {
                boolean bl2 = false;
                result$iv$iv = ca.getSubjectCN();
                result$iv$iv = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final String get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                result$iv$iv = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)result$iv$iv);
            $i$f$assertDoesNotThrow = false;
            $i$f$evaluateAndWrap = false;
            try {
                boolean bl3 = false;
                result$iv$iv = ca.getIssuerCN();
                result$iv$iv = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final String get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                result$iv$iv = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)result$iv$iv);
            $i$f$assertDoesNotThrow = false;
            $i$f$evaluateAndWrap = false;
            try {
                boolean bl4 = false;
                result$iv$iv = ca.getCaNumber();
                result$iv$iv = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final Integer get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                result$iv$iv = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)result$iv$iv);
            $i$f$assertDoesNotThrow = false;
            $i$f$evaluateAndWrap = false;
            try {
                boolean bl5 = false;
                result$iv$iv = ca.isCrossCa();
                throwingSupplier = new ThrowingSupplier(result$iv$iv){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = object;
                    }

                    public final Boolean get() {
                        return this.$result;
                    }
                };
            }
            catch (Throwable throwable$iv$iv) {
                throwingSupplier = new ThrowingSupplier(throwable$iv$iv){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = throwable;
                    }

                    @NotNull
                    public final Void get() {
                        throw this.$throwable;
                    }
                };
            }
            Assertions.assertDoesNotThrow((ThrowingSupplier)throwingSupplier);
            Assertions.assertNotNull((Object)ca.getCert());
        }
    }

    private static final CharSequence setup$lambda$2$lambda$0(Certs it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getHref();
    }
}

