/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ncpeh.api.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;

@Schema(enumAsRef=true, name="SlotName")
public enum SlotName {
    FORMAT_CODE("$XDSDocumentEntryFormatCode"),
    ENTRY_TYPE_CODE("$XDSDocumentEntryTypeCode"),
    PRACTICE_SETTING_CODE("$XDSDocumentEntryPracticeSettingCode"),
    CREATION_TIME_FROM("$XDSDocumentEntryCreationTimeFrom"),
    CREATION_TIME_TO("$XDSDocumentEntryCreationTimeTo"),
    SERVICE_START_TIME_FROM("$XDSDocumentEntryServiceStartTimeFrom"),
    SERVICE_START_TIME_TO("$XDSDocumentEntryServiceStartTimeTo"),
    SERVICE_STOP_TIME_FROM("$XDSDocumentEntryServiceStopTimeFrom"),
    SERVICE_STOP_TIME_TO("$XDSDocumentEntryServiceStopTimeTo"),
    HEALTHCARE_FACILITY_TYPE_CODE("$XDSDocumentEntryHealthcareFacilityTypeCode"),
    EVENT_CODE_LIST("$XDSDocumentEntryEventCodeList"),
    CONFIDENTIALITY_CODE("$XDSDocumentEntryConfidentialityCode"),
    AUTHOR_PERSON("$XDSDocumentEntryAuthorPerson"),
    TYPE("$XDSDocumentEntryType");

    private final String name;

    private SlotName(String name) {
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    @JsonCreator
    public static SlotName fromValue(@NonNull String name) {
        Objects.requireNonNull(name, "name is marked non-null but is null");
        return Arrays.stream(SlotName.values()).filter(value -> name.equalsIgnoreCase(value.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No slot name %s is known", name)));
    }
}

