/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ncpeh.api.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;

@Schema(enumAsRef=true)
public enum Saml2AttributeName {
    SUBJECT_ID("urn:oasis:names:tc:xspa:1.0:subject:subject-id"),
    SUBJECT_ROLE("urn:oasis:names:tc:xacml:2.0:subject:role"),
    SUBJECT_ORGANIZATION("urn:oasis:names:tc:xspa:1.0:subject:organization"),
    SUBJECT_ORGANIZATION_ID("urn:oasis:names:tc:xspa:1.0:subject:organization-id"),
    SUBJECT_ON_BEHALF_OF("urn:ehdsi:names:subject:on-behalf-of"),
    HEALTHCARE_FACILITY_TYPE("urn:ehdsi:names:subject:healthcare-facility-type"),
    ENVIRONMENT_LOCALITY("urn:oasis:names:tc:xspa:1.0:environment:locality"),
    SUBJECT_CLINICAL_SPECIALTY("urn:ehdsi:names:subject:clinical-speciality");

    private final String attributeName;
    public static final int VALUE_COUNT;

    private Saml2AttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @JsonValue
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonCreator
    public static Saml2AttributeName fromString(@NonNull String attributeName) {
        Objects.requireNonNull(attributeName, "attributeName is marked non-null but is null");
        return Arrays.stream(Saml2AttributeName.values()).filter(value -> attributeName.equalsIgnoreCase(value.getAttributeName())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No Saml2 attribute name %s is known", attributeName)));
    }

    static {
        VALUE_COUNT = Saml2AttributeName.values().length;
    }
}

